<?php
function generatePassword($length, $requirements, $entropy) {
    $chars = '';
    $password = '';
    
    if (in_array('uppercase', $requirements)) {
        $chars .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    }
    if (in_array('lowercase', $requirements)) {
        $chars .= 'abcdefghijklmnopqrstuvwxyz';
    }
    if (in_array('numbers', $requirements)) {
        $chars .= '0123456789';
    }
    if (in_array('special', $requirements)) {
        $chars .= '!@#$%^&*';
    }
    
    if (empty($chars)) {
        return ['error' => 'Please select at least one character type'];
    }

    $entropyCommand = "qrandom --level " . $entropy . " --bytes " . $length;
    $output = [];
    exec($entropyCommand, $output);
    
    if (!empty($output)) {
        $seed = hexdec(substr($output[0], 0, 8));
        mt_srand($seed);
    }

    for ($i = 0; $i < $length; $i++) {
        $password .= $chars[mt_rand(0, strlen($chars) - 1)];
    }

    return ['password' => $password];
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $length = isset($_GET['length']) ? (int)$_GET['length'] : 12;
    if ($length < 8 || $length > 64) {
        $length = 12;
    }

    $requirements = isset($_GET['requirements']) ? $_GET['requirements'] : ['lowercase', 'uppercase', 'numbers'];
    if (!is_array($requirements)) {
        $requirements = ['lowercase', 'uppercase', 'numbers'];
    }

    $entropy = isset($_GET['entropy']) ? $_GET['entropy'] : 'medium';

    try {
        $result = generatePassword($length, $requirements, $entropy);
        if (isset($result['error'])) {
            $error = $result['error'];
        } else {
            $password = $result['password'];
        }
    } catch (Exception $e) {
        $error = 'Failed to generate password';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generated Password</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .password-container {
            position: relative;
        }
        .password-field {
            font-family: monospace;
            letter-spacing: 2px;
            cursor: pointer;
        }
        .password-field.masked {
            -webkit-text-security: disc;
        }
    </style>
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h3 class="mb-0">Generated Password</h3>
                    </div>
                    <div class="card-body">
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger mb-4">
                                <?php echo htmlspecialchars($error); ?>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info mb-4">
                                Hover over the password to reveal it. Click the copy button to copy to clipboard.
                            </div>
                            <div class="password-container mb-3">
                                <div id="passwordField" class="password-field masked p-3 bg-light border rounded">
                                    <?php echo htmlspecialchars($password ?? ''); ?>
                                </div>
                            </div>
                            <div class="d-flex gap-2">
                                <button id="copyBtn" class="btn btn-primary">
                                    Copy to Clipboard
                                </button>
                                <a href="index.php" class="btn btn-secondary">
                                    Generate Another
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        const passwordField = document.getElementById('passwordField');
        if (passwordField) {
            passwordField.addEventListener('mouseenter', () => {
                passwordField.classList.remove('masked');
            });
            passwordField.addEventListener('mouseleave', () => {
                passwordField.classList.add('masked');
            });

            document.getElementById('copyBtn')?.addEventListener('click', async () => {
                try {
                    await navigator.clipboard.writeText(passwordField.textContent.trim());
                    alert('Password copied to clipboard!');
                } catch (err) {
                    alert('Failed to copy password');
                }
            });
        }
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
