<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quantum Password Generator</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h3 class="mb-0">Quantum-Enhanced Password Generator</h3>
                    </div>
                    <div class="card-body">
                        <p class="text-muted">
                            Generate cryptographically secure passwords using quantum entropy for enhanced randomness.
                        </p>
                        <form action="generate_password.php" method="GET">
                            <div class="mb-3">
                                <label for="length" class="form-label">Password Length</label>
                                <input type="number" class="form-control" id="length" name="length" min="8" max="64" value="12" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Include Characters:</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="uppercase" name="requirements[]" value="uppercase" checked>
                                    <label class="form-check-label" for="uppercase">Uppercase Letters (A-Z)</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="lowercase" name="requirements[]" value="lowercase" checked>
                                    <label class="form-check-label" for="lowercase">Lowercase Letters (a-z)</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="numbers" name="requirements[]" value="numbers" checked>
                                    <label class="form-check-label" for="numbers">Numbers (0-9)</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="special" name="requirements[]" value="special">
                                    <label class="form-check-label" for="special">Special Characters (!@#$%^&*)</label>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="entropy" class="form-label">Quantum Entropy Level</label>
                                <select class="form-select" id="entropy" name="entropy">
                                    <option value="low">Low (Faster)</option>
                                    <option value="medium" selected>Medium (Recommended)</option>
                                    <option value="high">High (Slower)</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">Generate Password</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>