#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

void print_usage() {
    fprintf(stderr, "Usage: qrandom --level <low|medium|high> --bytes <number>\n");
    exit(1);
}

int get_delay_for_level(const char* level) {
    if (strcmp(level, "low") == 0) return 100000;
    if (strcmp(level, "medium") == 0) return 300000;
    if (strcmp(level, "high") == 0) return 500000;
    return 300000;
}

int main(int argc, char *argv[]) {
    char *level = NULL;
    int bytes = 0;
    
    for (int i = 1; i < argc; i++) {
        if (strcmp(argv[i], "--level") == 0 && i + 1 < argc) {
            level = argv[i + 1];
            i++;
        } else if (strcmp(argv[i], "--bytes") == 0 && i + 1 < argc) {
            bytes = atoi(argv[i + 1]);
            i++;
        }
    }
    
    if (!level || bytes <= 0) {
        print_usage();
    }

    srand(time(NULL));
    int delay = get_delay_for_level(level);
    for (int i = 0; i < delay; i++) {
        asm volatile("nop");
    }
    
    for (int i = 0; i < bytes; i++) {
        unsigned char byte = (unsigned char)(rand() & 0xFF);
        printf("%02x", byte); 
    }
    printf("\n");
    
    return 0;
}
