
;  ethical.blue Magazine // Cybersecurity clarified.

.data
mem256 dword 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0
mem256b dword 1, 2, 3, 4, 5, 6, 7, 8

.code
Main proc
    ;[i] Memory data that is aligned on a 16 byte boundary will have
    ;    a memory address that is a multiple of two.

    ;VMOVUPS  Move Unaligned Packed Floating-Point Values
    mov rdx, offset mem256
    vmovups ymm0, ymmword ptr [rdx]

    ;VMOVAPS  Move Aligned Packed Floating-Point Values
    ;When MOV between registers it is best to use the aligned version.
    vmovaps ymm1, ymm0
    
    ;VMOVDQU  Move Unaligned Packed Integer Values
    mov rdx, offset mem256b
    vmovdqu ymm0, ymmword ptr [rdx]

    ;VMOVDQA  Move Aligned Packed Integer Values
    ;When MOV between registers it is best to use the aligned version.
    vmovdqa ymm1, ymm0
    
    mov r8, sizeof ymmword ;256 bits == 32 bytes

    ret
Main endp
end
