// closehandle.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>

void EnableDebugPriv(VOID)
{
	HANDLE hToken = NULL;
	TOKEN_PRIVILEGES newPrivs;
	memset(&newPrivs, 0x0, sizeof(newPrivs));
	if (!OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES, &hToken)) {
		return;
	}
	if (!LookupPrivilegeValue(NULL,SE_DEBUG_NAME, &newPrivs.Privileges[0].Luid)) {
		CloseHandle(hToken);
		return;
	}
	newPrivs.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
	newPrivs.PrivilegeCount = 1;
	AdjustTokenPrivileges(hToken, FALSE, &newPrivs, 0, NULL, NULL);
	CloseHandle(hToken);
	return;
}

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc != 3) { 
		_tprintf(_T("Usage: %s <pid> <handle>\n"), argv[0]);
		return -1;
	}

	EnableDebugPriv();

	DWORD dwPid  = _tcstoul(argv[1], NULL, 0); 
	DWORD dwHval = _tcstoul(argv[2], NULL, 0); 

	HANDLE hDupHandle;
	BOOL bStatus = FALSE;

	printf("Trying to close handle: %x\n", dwHval);

	return -1;

	HANDLE hProc = OpenProcess(PROCESS_DUP_HANDLE, FALSE, dwPid);
	if (hProc != NULL) { 
		if (DuplicateHandle(hProc, 
			(HANDLE)dwHval, GetCurrentProcess(), &hDupHandle, 
			0, FALSE, 
			DUPLICATE_SAME_ACCESS|DUPLICATE_CLOSE_SOURCE)) {
				if (CloseHandle(hDupHandle)) { 
					bStatus = TRUE;
				} else { 
					_tprintf(_T("Cannot close handle: %d\n"), GetLastError());
				}
		} else { 
			_tprintf(_T("Cannot duplicate handle: %d\n"), GetLastError());
		}
		CloseHandle(hProc);
	} else { 
		_tprintf(_T("Cannot open process: %d\n"), GetLastError());
	}

	if (bStatus) { 
		_tprintf(_T("Remote handle close succeeded!\n"));
	} else {
		_tprintf(_T("Cannot close the remote handle!\n"));
	}

	return 0;
}

