#include <windows.h>
#include <stdio.h>

/*-------------------------------------------------------------------------------
|
| This gives us the ability to open processes with proper permissions 
|
/-------------------------------------------------------------------------------*/

void EnableDebug(void)
{
	HANDLE hToken = NULL;
	TOKEN_PRIVILEGES priv;

	memset(&priv, 0, sizeof(priv));
	if (!OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES, &hToken)) {
		return;
	}

	if (!LookupPrivilegeValue(NULL,SE_DEBUG_NAME, &priv.Privileges[0].Luid)) {
		CloseHandle(hToken);
		return;
	}

	priv.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
	priv.PrivilegeCount = 1;

	AdjustTokenPrivileges(hToken, FALSE, &priv, 0, NULL, NULL);
	CloseHandle(hToken);
}

LPBYTE RemoteWrite(HANDLE hProc, 
				   char * thestr)
{
	DWORD len = strlen(thestr);
	DWORD cb  = 0;
	BOOL  ret = FALSE;

	LPBYTE ptr = (LPBYTE) VirtualAllocEx(
		hProc, 
		NULL, 
		len + 1,
		MEM_COMMIT|MEM_RESERVE, 
		PAGE_READWRITE);

	if (ptr == NULL) {
		printf("[ERROR] VirtualAllocEx failed: %d\n", 
			GetLastError());
		return NULL;
	}

	ret = WriteProcessMemory(hProc, ptr, thestr, len, &cb);

	if (!ret || !cb) {
		printf("[ERROR] WriteProcessMemory failed: %d\n", 
			GetLastError());
		return NULL;
	}

	printf("[INFO] Wrote %d bytes to 0x%x: %s\n", 
		cb, ptr, thestr);
	return ptr;
}

HANDLE RemoteThread(HANDLE hproc, 
					DWORD  pstart, 
					LPVOID pparam)
{
	DWORD  tid = 0;
	HANDLE hthread = NULL;
	
	hthread = CreateRemoteThread(
		hproc,							/* handle to remote process */
		NULL,						    /* no special security */
		0,								/* default stack size */
		(LPTHREAD_START_ROUTINE)pstart,	/* thread start address */
		pparam,					     	/* thread parameter - dll name */
		0,								/* no special creation flags */
		&tid);				     		/* receives thread id */
	
	if (hthread == NULL) { 
		printf("[ERROR] CreateRemoteThread failed: %d\n", 
			GetLastError());
		return NULL;
	}

	return hthread;
}

/*-------------------------------------------------------------------------------
|
| Generic function to inject DLLs into a remote process and optionally
| call one of its exported function
|
/-------------------------------------------------------------------------------*/

void InjectDllEx(HANDLE hproc, 
				 char * dllpath, 
				 char * exp, 
				 char * exparg)
{
	DWORD   dwRemoteBase = 0; 
	HMODULE hmod = NULL;
	FARPROC pfunc = NULL;
	LPBYTE  r_exparg = NULL;
	DWORD   exitcode = 0;
	DWORD   expaddr = 0;
	HANDLE  hthread = NULL;

	LPBYTE r_dllpath = RemoteWrite(hproc, dllpath);

	if (r_dllpath == NULL) { 
		return;
	}

	hthread = RemoteThread(hproc, (DWORD)LoadLibraryA, r_dllpath);

	if (hthread == NULL) {
		return;
	}

	WaitForSingleObject(hthread, INFINITE);
	GetExitCodeThread(hthread, &dwRemoteBase);
	CloseHandle(hthread);

	if (!dwRemoteBase) { 
		printf("[ERROR] LoadLibraryA failed!\n");
		return;
	}

	printf("[INFO] Remote DLL base: 0x%x\n", dwRemoteBase);

	if (exp != NULL)
	{
		hmod  = LoadLibraryExA(dllpath, NULL, DONT_RESOLVE_DLL_REFERENCES);
		pfunc = GetProcAddress(hmod, exp);

		if (!pfunc) { 
			printf("[ERROR] Cannot locate %s\n", exp);
			return;
		}
		
		expaddr = dwRemoteBase + ((DWORD)pfunc - (DWORD)hmod);

		printf("[INFO] Found %s at 0x%x\n", exp, expaddr);

		r_exparg = RemoteWrite(hproc, exparg);

		if (r_exparg == NULL) { 
			return;
		}

		hthread = RemoteThread(hproc, expaddr, r_exparg);

		if (hthread != NULL)
		{
			WaitForSingleObject(hthread, 1000);
			GetExitCodeThread(hthread, &exitcode);
			CloseHandle(hthread);
			printf("[INFO] %s returned 0x%x\n", exp, exitcode);
		}
	} 
}

void usage(char *prog) 
{
	printf("Usage: %s <PID-decimal> <c:\\your.dll> [export] [arg]\n", prog);
}

int main (int argc, char *argv[])
{
	printf("[INFO] This program is for 32bit XP only.\n");

	if (argc < 3) { 
		usage(argv[0]);
		return -1;
	}
	
	EnableDebug();
	DWORD pid = atoi(argv[1]);

	HANDLE hProc = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pid);

	if (hProc == NULL) { 
		printf("[ERROR] OpenProcess failed for pid %d: %d\n", 
			pid, GetLastError());
		return -1;
	}

	char * exp = NULL;
	char * exparg = NULL;

	if (argc > 3) { 
		exp = argv[3];
		if (argc > 4) { 
			exparg = argv[4];
		}
	}

	printf("[INFO] Target process has pid %d\n", pid);
	
	InjectDllEx(hProc, argv[2], exp, exparg);
	CloseHandle(hProc);
	return 0;
}