// preservation.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"

#define IOCTL_HOOK_PROCESS 0x01010101
#define IOCTL_HOOK_FILES   0x02020202
#define IOCTL_NOTIFY_ROUTINES  0x03030303
#define IOCTL_HOOK_DRIVERS 0x04040404

BOOL UnloadDriver(void)
{
	SERVICE_STATUS lpServiceStatus;
	SC_HANDLE hService;
	SC_HANDLE hSCM;
	
	hSCM = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if(!hSCM) {
		_tprintf(_T("Cannot open SCM: %d\n"), GetLastError());
		return FALSE;
	}

	hService = OpenService(
		hSCM, 
		_T("Preservation"),
		SERVICE_ALL_ACCESS);

	if (!hService) 
	{
		_tprintf(_T("Cannot open/create service: %d\n"), GetLastError());
		CloseServiceHandle(hSCM);
		return FALSE;
	}

	if (!ControlService(hService, 
		SERVICE_CONTROL_STOP, &lpServiceStatus))
	{
		_tprintf(_T("Cannot stop service: %d\n"), GetLastError());
		return FALSE;
	}

	CloseServiceHandle(hService);
	CloseServiceHandle(hSCM);

	return TRUE;
}

BOOL LoadDriver(TCHAR * szDriverPath)
{
	SC_HANDLE hSCM;
	SC_HANDLE hService;

	hSCM = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if(!hSCM) {
		_tprintf(_T("Cannot open SCM: %d\n"), GetLastError());
		return FALSE;
	}

	hService = OpenService(
		hSCM, 
		_T("Preservation"),
		SERVICE_ALL_ACCESS);

	if (!hService)
	{
		hService = CreateService(
			hSCM, 
			_T("Preservation"), 
			_T("Preservation"), 
			SERVICE_ALL_ACCESS, 
			SERVICE_KERNEL_DRIVER, 
			SERVICE_DEMAND_START,
			SERVICE_ERROR_NORMAL, 
			szDriverPath, 
			NULL, NULL, NULL, 
			NULL, NULL);

		if(!hService) 
		{
			_tprintf(_T("Cannot open/create service: %d\n"), GetLastError());
			CloseServiceHandle(hSCM);
			return FALSE;
		}
	}
	
	if (!StartService(hService, 0, NULL)) 
	{
		_tprintf(_T("Cannot start service: %d\n"), GetLastError());
		CloseServiceHandle(hSCM);
		return FALSE;
	}

	CloseServiceHandle(hService);
	CloseServiceHandle(hSCM);
	return TRUE;
}

BOOL SendIOCTL(DWORD Code)
{
	ULONG BytesReturned;
	HANDLE hDevice;
	BOOL bStatus;

	hDevice = CreateFile(
		_T("\\\\.\\Preservation"), 
        GENERIC_ALL, 
        FILE_SHARE_READ | FILE_SHARE_WRITE, 
        NULL, OPEN_EXISTING, 
        FILE_ATTRIBUTE_NORMAL, 
        NULL);

	if (hDevice == INVALID_HANDLE_VALUE)
		return FALSE;

	bStatus = DeviceIoControl(hDevice, 
				Code, 
				NULL, 0, NULL, 0, 
				&BytesReturned, NULL);

	CloseHandle(hDevice);
	return bStatus;
}

void PrintUsage(TCHAR *szModule)
{
	_tprintf(_T("\nUsage: %s [OPTIONS]"), szModule);
	_tprintf(_T("\nOPTIONS:"));
	_tprintf(_T("\n  l     load driver and log actions"));
	_tprintf(_T("\n  f     prevent file deletions"));
	_tprintf(_T("\n  d     prevent driver loading"));
	_tprintf(_T("\n  p     prevent process termination"));
	_tprintf(_T("\n  n     install notify routines"));
	_tprintf(_T("\n  u     unload the driver"));
	_tprintf(_T("\nEXAMPLE:"));
	_tprintf(_T("\n  %s lfdpn (prevent and log all)"), szModule);
	_tprintf(_T("\n  %s l (allow and log all)\n"), szModule);
}

/*void GetDirectoryName(CHAR *szDirectory)
{
	SYSTEMTIME st;
	GetSystemTime(&st);
	sprintf(szDirectory, "pres_%d_%d_%d_%d", 
		st.wMonth, 
		st.wDay, 
		st.wHour, 
		st.wMinute);
}*/

void EnableDebugPriv(VOID)
{
	HANDLE hToken = NULL;
	TOKEN_PRIVILEGES newPrivs;

	memset(&newPrivs, 0x0, sizeof(newPrivs));
	if (!OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES, &hToken)) {
		return;
	}

	if (!LookupPrivilegeValue(NULL,SE_DEBUG_NAME, &newPrivs.Privileges[0].Luid)) {
		CloseHandle(hToken);
		return;
	}

	newPrivs.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
	newPrivs.PrivilegeCount = 1;

	AdjustTokenPrivileges(hToken, FALSE, &newPrivs, 0, NULL, NULL);
	CloseHandle(hToken);
	return;
}

int _tmain(int argc, _TCHAR* argv[])
{
	TCHAR szDriverPath[MAX_PATH*2];
	HANDLE hDevice;
	CHAR szDirectory[MAX_PATH];

	/*EnableDebugPriv();
	HANDLE hProc = OpenProcess(PROCESS_ALL_ACCESS, TRUE, 3284);
	TerminateProcess(hProc, -2);
	return 0;*/

	_tprintf(_T("\n*\n* Preservation Driver Loader\n*\n"));

	if (argc != 2) { 
		PrintUsage(argv[0]);
		return -1;
	}

	if (_tcschr(argv[1], _T('u')) != NULL)
	{
		if (UnloadDriver()) { 
			_tprintf(_T("Driver unloaded.\n"));
		} else {
			_tprintf(_T("Cannot unload driver.\n"));
		}
		return 0;
	}
		
	CreateDirectory(_T("C:\\PreservationLogs"), NULL);

	//GetDirectoryName(szDirectory);
	GetCurrentDirectory(MAX_PATH, szDriverPath);
	_tcscat(szDriverPath, _T("\\"));
	_tcscat(szDriverPath, _T("preservation.sys"));

	if (LoadDriver(szDriverPath)) { 

		_tprintf(_T("Driver loaded.\n"));
		Sleep(2000);

		if (_tcschr(argv[1], _T('p')) != NULL) {
			_tprintf(_T("Enabling process hooks\n"));
			SendIOCTL(IOCTL_HOOK_PROCESS);
		}
		if (_tcschr(argv[1], _T('f')) != NULL) {
			_tprintf(_T("Enabling file hooks\n"));
			SendIOCTL(IOCTL_HOOK_FILES);
		}
		if (_tcschr(argv[1], _T('n')) != NULL) {
			_tprintf(_T("Enabling notification routines\n"));
			SendIOCTL(IOCTL_NOTIFY_ROUTINES);
		}
		if (_tcschr(argv[1], _T('d')) != NULL) {
			_tprintf(_T("Enabling driver hooks\n"));
			SendIOCTL(IOCTL_HOOK_DRIVERS);
		}
	} else {
		_tprintf(_T("Cannot load driver.\n"));
		return -1;
	}

	_tprintf(_T("See C:\\Preservation for logs!\n"));
	return 0;
}

