#include <precomp.h>

void StripCRLF(LPTSTR first)
{
	int in=0;
	int out=0;
	
	for(in=0; in < _tcslen(first); in++)
	{
		TCHAR c = first[in];
		if (c != _T('\n') && c != _T('\r'))
			first[out++] = c;
	}
	
	first[out] = _T('\x00');
}

void LogCommand(LPTSTR first)
{
	TCHAR * dup = NULL;
	FILE * LOG = NULL;
	
	dup = _tcsdup(first);
	if (dup == NULL) {
	    error_out_of_memory();
		return;
    }

	LOG = _tfopen(_T("C:\\commands.log"), _T("a"));
	
	if (LOG != NULL) {
		StripCRLF(dup);
		_ftprintf(LOG, _T("> %s\n"), dup);
		fclose(LOG);
	}
	
	free(dup);
}

void LogStart(void)
{
    TCHAR buf[256];
	_stprintf(buf, _T("** New Command Shell [PID:%d]"), GetCurrentProcessId());
	LogCommand(buf);
}

void LogCommandWithArgs(LPTSTR cmd, LPTSTR args)
{
    TCHAR * com = NULL;
    
    com = cmd_alloc((_tcslen(cmd) + _tcslen(args) + 2) * sizeof(TCHAR));
	if (com == NULL)
	{
		error_out_of_memory();
		return;
	}
	_tcscpy(com, cmd);
	_tcscat(com, args);
	LogCommand(com);
	cmd_free(com);
}