/*
 * Copyright (C) 1998
 *	Sony Computer Science Laboratories Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SONY CSL AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL SONY CSL OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: tcpdstat.h,v 1.6 2001/03/26 07:23:03 kjc Exp kjc $
 */

struct pkt_cnt {
	int	packets;
	long long bytes;
};

enum protos {
	TOTAL,
	  IP, 
	    TCP_IP,
	      HTTP_S_TCP, HTTP_C_TCP, SQUID_TCP, SMTP_TCP, NNTP_TCP,
	      FTP_TCP, POP3_TCP,
	      IMAP_TCP, TELNET_TCP, SSH_TCP, DNS_TCP,  BGP_TCP,
	      NAPSTER_TCP, REALAUDIO_TCP, RTSP_TCP, SHOUTCAST_TCP,
	      HOTLINE_TCP,
	      OTHER_TCP,
	    UDP_IP,
	      DNS_UDP, RIP_UDP, MCAST_UDP,
	      REALAUDIO_UDP, HALFLIFE_UDP, STARCRAFT_UDP, EVERQUEST_UDP,
	      UNREAL_UDP, QUAKE_UDP, CUSEEME_UDP,
	      OTHER_UDP,
	    ICMP_IP, IGMP_IP, OSPF_IP, IP_IP, IPSEC_IP, IP6_IP, PIM_IP,
	    SCTP_IP, OTHER_IP, FRAG_IP, 
	IP6,
	    TCP_IP6,
	      HTTP_S_TCP6, HTTP_C_TCP6, SQUID_TCP6, SMTP_TCP6, NNTP_TCP6,
	      FTP_TCP6, POP3_TCP6,
	      IMAP_TCP6, TELNET_TCP6, SSH_TCP6, DNS_TCP6, BGP_TCP6,
	      NAPSTER_TCP6, REALAUDIO_TCP6, RTSP_TCP6, SHOUTCAST_TCP6,
	      HOTLINE_TCP6,
	      OTHER_TCP6,
	    UDP_IP6,
	      DNS_UDP6, RIP_UDP6, MCAST_UDP6,
	      REALAUDIO_UDP6, HALFLIFE_UDP6, STARCRAFT_UDP6, EVERQUEST_UDP6,
	      UNREAL_UDP6, QUAKE_UDP6, CUSEEME_UDP6,
	      OTHER_UDP6,
	    ICMP_IP6, OSPF_IP6, IP_IP6, IP6_IP6, IPSEC_IP6, HBHOPT_IP6,
	    RTOPT_IP6, DSTOPT_IP6, PIM_IP6,
	    SCTP_IP6, OTHER_IP6, FRAG_IP6, 
	OTHER,
	PROTOTYPE_MAX
};

extern int read_count;
extern struct timeval start_time, end_time;
extern struct pkt_cnt tcpdstat[PROTOTYPE_MAX];
//extern int packet_length;
extern int caplen_total;
extern int caplen_max;
extern int use_ipflow;
extern double rate_mean;
extern double rate_var;
extern int rate_count;
extern int debug;

int open_dump(char *);
void close_dump(void);
int read_dump(void);

void pktsize_add(int size);

void ipflow_destroy(void);
void ipflow_show(void);
int ipflow_count(int, struct ip *, int);



