import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Menus extends JFrame implements ActionListener, ItemListener{
	JMenuBar barraMenu;
      JMenu menu, submenu;
      JMenuItem elementoMenu;
      JRadioButtonMenuItem rbElementoMenu;
      JCheckBoxMenuItem cbElementoMenu;
	
	JPopupMenu menuPopup;

	JTextArea texto;
    	JScrollPane panelScroll;

	public Menus(){
		super("Ventana con mltiples mens");
		this.addWindowListener(new WindowAdapter() {
            	public void windowClosing(WindowEvent e) {
                		System.exit(0);
            	}
        	});
	}
	
	public void creaMenu(){
		//Se crea la barra de men
        	barraMenu = new JMenuBar();
        	setJMenuBar(barraMenu);

       	//se crea el primer men
        	menu = new JMenu("Un Men");
       	menu.setMnemonic(KeyEvent.VK_E);
       	barraMenu.add(menu);

       	//unos cuantos elementos de men
        	elementoMenu=new JMenuItem("Elemento de men de texto",KeyEvent.VK_E);
        	elementoMenu.addActionListener(this);
        	menu.add(elementoMenu);
		//se asigna tecla de acceso rpido
		elementoMenu.setAccelerator(KeyStroke.getKeyStroke(
						KeyEvent.VK_1, ActionEvent.ALT_MASK));


       	elementoMenu=new JMenuItem("Texto e icono",new ImageIcon("icono2.gif"));
        	elementoMenu.setMnemonic(KeyEvent.VK_T);
        	elementoMenu.addActionListener(this);
        	menu.add(elementoMenu);

       	elementoMenu=new JMenuItem(new ImageIcon("icono2.gif"));
        	elementoMenu.setMnemonic(KeyEvent.VK_D);
        	elementoMenu.addActionListener(this);
        	menu.add(elementoMenu);
		
		//se aade un separador
		menu.addSeparator();

		//un grupo de elementos de men de botones de opcin.
        	ButtonGroup grupo=new ButtonGroup();
        	rbElementoMenu=new JRadioButtonMenuItem("Botn de opcin");
        	rbElementoMenu.setSelected(true);
        	rbElementoMenu.setMnemonic(KeyEvent.VK_O);
        	grupo.add(rbElementoMenu);
        	rbElementoMenu.addActionListener(this);
        	menu.add(rbElementoMenu);
        	rbElementoMenu= new JRadioButtonMenuItem("Otro botn de opcin");
        	rbElementoMenu.setMnemonic(KeyEvent.VK_B);
        	grupo.add(rbElementoMenu);
        	rbElementoMenu.addActionListener(this);
        	menu.add(rbElementoMenu);

       	 //Un grupo de casillas de verificacin
        	menu.addSeparator();
        	cbElementoMenu=new JCheckBoxMenuItem("Casilla de verificacin");
        	cbElementoMenu.setMnemonic(KeyEvent.VK_C);
        	cbElementoMenu.addItemListener(this);
        	menu.add(cbElementoMenu);
       	cbElementoMenu=new JCheckBoxMenuItem("Otro ms");
        	cbElementoMenu.setMnemonic(KeyEvent.VK_M);
        	cbElementoMenu.addItemListener(this);
        	menu.add(cbElementoMenu);

        	//un submen
       	menu.addSeparator();
        	submenu=new JMenu("Un submen");
        	submenu.setMnemonic(KeyEvent.VK_S);

        	elementoMenu=new JMenuItem("Un elemento de men del submen");
        	elementoMenu.setAccelerator(KeyStroke.getKeyStroke(
                				KeyEvent.VK_2, ActionEvent.ALT_MASK));
        	elementoMenu.addActionListener(this);
        	submenu.add(elementoMenu);

        	elementoMenu= new JMenuItem("Otro elemento de men");
        	elementoMenu.addActionListener(this);
        	submenu.add(elementoMenu);
        	menu.add(submenu);

        	//Segndo men de la barra de men
        	menu = new JMenu("Otro Men");
        	menu.setMnemonic(KeyEvent.VK_M);
        
 	      barraMenu.add(menu);

	}

	public void creaPopup(){
		menuPopup=new JPopupMenu();
		//se crean y aadden los distinos elementos de men de la misma manera
        	elementoMenu=new JMenuItem("Primer elemento del popup",KeyEvent.VK_P);
        	elementoMenu.addActionListener(this);
        	menuPopup.add(elementoMenu);
		elementoMenu=new JMenuItem("Segundo del popup",new ImageIcon("icono2.gif"));
        	elementoMenu.setMnemonic(KeyEvent.VK_S);
        	elementoMenu.addActionListener(this);
        	menuPopup.add(elementoMenu);
		menuPopup.addSeparator();
        	cbElementoMenu=new JCheckBoxMenuItem("Tercer elemento");
        	cbElementoMenu.setMnemonic(KeyEvent.VK_T);
        	cbElementoMenu.addItemListener(this);
        	menuPopup.add(cbElementoMenu);
		//se crea el oyente y se registra para el rea de texto
		PopupListener oyente=new PopupListener();
		texto.addMouseListener(oyente);	
	}

	public void creaTexto(){
		texto= new JTextArea(10, 50);
        	texto.setEditable(false);
        	panelScroll= new JScrollPane(texto);
        	getContentPane().add(panelScroll, BorderLayout.CENTER);

	}

	public void actionPerformed(ActionEvent evento){
		JMenuItem fuente=(JMenuItem)(evento.getSource());
        	String mensaje= "ActionEvent detectado.\n"
                   + "    Fuente del evento: " + fuente.getText()+"\n";
        	texto.append(mensaje);
	}

	public void itemStateChanged(ItemEvent evento) {
		String estado="";
        	JMenuItem fuente =(JMenuItem)(evento.getSource());
		if (evento.getStateChange()==ItemEvent.SELECTED)
			estado="Seleccionado";
		else
			estado="No seleccionado";
        	String mensaje="ItemEvent detectado.\n"
                   + "    Fuente del evento: " + fuente.getText()+"\n"
                   + "    Nuevo estado: "+estado+"\n";
        	texto.append(mensaje);
    	}


	public static void main(String s[]) {
		Menus ventana = new Menus();
		ventana.creaMenu();
		ventana.creaTexto();
		ventana.creaPopup();
		ventana.pack();
        	ventana.setVisible(true);
	}
	
	//clase interna adaptadora
	class PopupListener extends MouseAdapter{
		public void mousePressed(MouseEvent evento){
			if (evento.isPopupTrigger()){
				menuPopup.show(evento.getComponent(),evento.getX(),evento.getY());
			}
		}
	}

}
