import java.awt.*;
import java.applet.*;
import java.awt.event.*;
public class Fuentes extends Applet implements ItemListener, TextListener{

private Choice tipoLetra, colorLetra;
private Checkbox negrita, cursiva;
private TextField tamao;
private Panel panelInterfaz, panel1, panel2,panel3,panel4,panel5;
private String tipo;
private int tam;
private Color color;
private int aspecto;
public void init(){
    creaInterfaz();
    tam=20;
    tipo="Arial";
    color=Color.green;
    aspecto=Font.PLAIN;
    tipoLetra.addItemListener(this);
    colorLetra.addItemListener(this);
    tamao.addTextListener(this);
    negrita.addItemListener(this);
    cursiva.addItemListener(this);
}
public void itemStateChanged(ItemEvent evento){
    if(evento.getSource()==tipoLetra){
        tipo=tipoLetra.getSelectedItem();
    }
    else if(evento.getSource()==colorLetra){
            color=devuelveColor(colorLetra.getSelectedItem());
    }
    else if(evento.getSource()==negrita){
            if (negrita.getState())
                aspecto=aspecto+Font.BOLD;
            else
                aspecto=aspecto-Font.BOLD;
    }
    else if (evento.getSource()==cursiva){
            if (cursiva.getState())
                aspecto=aspecto+Font.ITALIC;
            else
                aspecto=aspecto-Font.ITALIC;
    }
    repaint();
}
public void textValueChanged(TextEvent evento){
    int t;
    try{
        t=Integer.parseInt(tamao.getText());
        tam=t;
        repaint();
    }
    catch (NumberFormatException ex){}
}
public Color devuelveColor(String col){
    if (col.equals("rojo"))
        return Color.red;
    else if (col.equals("azul"))
            return Color.blue;
    else return Color.green;
}
public void paint(Graphics g){
    g.setFont(new Font(tipo,aspecto,tam));
    g.setColor(color);
    g.drawString("Hola Mundo",10,180);
}
public void creaInterfaz(){
        //panel que contiene todo el interfaz
        panelInterfaz=new Panel();
        panelInterfaz.setLayout(new GridLayout(2,1));
        //panel que contiene los controles de tamao y aspecto de la fuente
        panel1=new Panel();
        panel1.setLayout(new GridLayout(1,3,5,1));
        //panel que contiene la caja de texto con el tamao de la fuente
        panel2=new Panel();
        panel2.setLayout(new BorderLayout());
        tamao=new TextField(10);
        panel2.add("North",new Label("Tamao"));
        panel2.add("South",tamao);
        panel1.add(panel2);
        negrita=new Checkbox("Negrita");
        panel1.add(negrita);
        cursiva=new Checkbox("Cursiva");
        panel1.add(cursiva);
        panelInterfaz.add(panel1);
        //panel que contiene las dos listas desplegables
        panel3=new Panel();
        panel3.setLayout(new GridLayout(1,2,5,1));
        //panel que contiene la lista con los tipos de letra
        panel4=new Panel();
        panel4.setLayout(new GridLayout(2,1));
        panel4.add(new Label("Tipo Letra:"));
        tipoLetra=new Choice();
        tipoLetra.addItem("Courier");
        tipoLetra.addItem("Arial");
        tipoLetra.addItem("TimesRoman");
        panel4.add(tipoLetra);
        panel3.add(panel4);
        //panel que contiene la lista con los colores
        panel5=new Panel();
        panel5.setLayout(new GridLayout(2,1));
        panel5.add(new Label("Color Letra:"));
        colorLetra=new Choice();
        colorLetra.addItem("rojo");
        colorLetra.addItem("azul");
        colorLetra.addItem("verde");
        panel5.add(colorLetra);
        panel3.add(panel5);
        panelInterfaz.add(panel3);
        add(panelInterfaz);
}
}
