import java.awt.event.*;
import javax.swing.*;
import java.awt.*;

public class LF extends JFrame implements ActionListener{
	private JMenuBar barraMenu;
      private JMenu menu, submenu;
      private JMenuItem elementoMenu;
      private JRadioButtonMenuItem rbElementoMenu;
      private JCheckBoxMenuItem cbElementoMenu;

	private JButton botonIzq;
	private JButton botonDer;
	private JButton botonCentro;

	private ImageIcon iconoIzq=new ImageIcon("icono3.gif");
	private ImageIcon icono=new ImageIcon("icono1.gif");
	private ImageIcon iconoCentro=new ImageIcon("icono2.gif");

	private JRadioButton opWindows;
	private JRadioButton opJava;
	private JRadioButton opMotif;
	private JRadioButton opSistema;
	private JRadioButton opMac;
	
	private JLabel etiqueta;

	private JPanel panelOpciones;

	JTextArea texto;
    	JScrollPane panelScroll;

	private JSlider selector;


	private JComboBox listaOpciones;

	String[] opciones={"Elemento uno","Elemento dos","Elemento tres"};


	public LF(){
		super("Pluggable Look & Feel");
		this.addWindowListener(new WindowAdapter() {
            	public void windowClosing(WindowEvent e) {
                		System.exit(0);
            	}
        	});
		try {
            	UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        	} catch (Exception e) { }
		getContentPane().setLayout(new BoxLayout(getContentPane(),BoxLayout.Y_AXIS));
	}


	public void creaMenu(){
        	barraMenu = new JMenuBar();
        	setJMenuBar(barraMenu);
        	menu = new JMenu("Un Men");
       	menu.setMnemonic(KeyEvent.VK_E);
       	barraMenu.add(menu);
        	elementoMenu=new JMenuItem("Elemento de men de texto",KeyEvent.VK_E);
        	menu.add(elementoMenu);
		elementoMenu.setAccelerator(KeyStroke.getKeyStroke(
						KeyEvent.VK_1, ActionEvent.ALT_MASK));

       	elementoMenu=new JMenuItem("Texto e icono",new ImageIcon("icono2.gif"));
        	elementoMenu.setMnemonic(KeyEvent.VK_T);
        	menu.add(elementoMenu);

       	elementoMenu=new JMenuItem(new ImageIcon("icono2.gif"));
        	elementoMenu.setMnemonic(KeyEvent.VK_D);
        	menu.add(elementoMenu);

		menu.addSeparator();

        	ButtonGroup grupo=new ButtonGroup();
        	rbElementoMenu=new JRadioButtonMenuItem("Botn de opcin");
        	rbElementoMenu.setSelected(true);
        	rbElementoMenu.setMnemonic(KeyEvent.VK_O);
        	grupo.add(rbElementoMenu);
        	menu.add(rbElementoMenu);
        	rbElementoMenu= new JRadioButtonMenuItem("Otro botn de opcin");
        	rbElementoMenu.setMnemonic(KeyEvent.VK_B);
        	grupo.add(rbElementoMenu);
        	menu.add(rbElementoMenu);

        	menu.addSeparator();
        	cbElementoMenu=new JCheckBoxMenuItem("Casilla de verificacin");
        	cbElementoMenu.setMnemonic(KeyEvent.VK_C);

        	menu.add(cbElementoMenu);
       	cbElementoMenu=new JCheckBoxMenuItem("Otro ms");
        	cbElementoMenu.setMnemonic(KeyEvent.VK_M);
        	menu.add(cbElementoMenu);
	}

	public void creaTexto(){
		texto= new JTextArea(5,30);
        	texto.setEditable(false);
        	panelScroll= new JScrollPane(texto);
		panelScroll.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        	getContentPane().add(panelScroll);

	}

	public void creaBotones(){
		botonIzq=new JButton("Boton 1",iconoIzq);
		botonIzq.setVerticalTextPosition(AbstractButton.CENTER);
		botonIzq.setHorizontalTextPosition(AbstractButton.LEFT);
		botonIzq.setMnemonic(KeyEvent.VK_D);
		botonIzq.setToolTipText("Un botn...");
		botonDer=new JButton("Botn 2");
		botonDer.setVerticalTextPosition(AbstractButton.CENTER);
		botonDer.setHorizontalTextPosition(AbstractButton.RIGHT);
		botonDer.setMnemonic(KeyEvent.VK_A);
		botonDer.setToolTipText("Soy el botn");
		botonCentro=new JButton("Botn central",iconoCentro);
		botonCentro.setToolTipText("No hago nada");
		JPanel panelBotones=new JPanel();
		panelBotones.add(botonIzq);
		panelBotones.add(botonCentro);
		panelBotones.add(botonDer);
		getContentPane().add(panelBotones);
	}

	public void creaOpciones(){
		panelOpciones=new JPanel();
		panelOpciones.setLayout(new GridLayout(1,5,5,5));

       	opWindows=new JRadioButton("Windows");
        	opWindows.setMnemonic(KeyEvent.VK_W); 
		opWindows.addActionListener(this);
		panelOpciones.add(opWindows);
	
		opJava=new JRadioButton("Java/Metal");
        	opJava.setMnemonic(KeyEvent.VK_J); 
		opJava.addActionListener(this);
		panelOpciones.add(opJava);
		opJava.setSelected(true);

		opMotif=new JRadioButton("Motif");
        	opMotif.setMnemonic(KeyEvent.VK_M); 
		opMotif.addActionListener(this);
		panelOpciones.add(opMotif);

		opMac=new JRadioButton("Mac");
        	opMac.setMnemonic(KeyEvent.VK_C); 
		opMac.addActionListener(this);
		panelOpciones.add(opMac);

		opSistema=new JRadioButton("Sistema");
        	opSistema.setMnemonic(KeyEvent.VK_S); 
		opSistema.addActionListener(this);
		panelOpciones.add(opSistema);
	
		panelOpciones.setBorder(BorderFactory.createLoweredBevelBorder());

		//se agrupan las opciones
		ButtonGroup grupo=new ButtonGroup();
		grupo.add(opWindows);
		grupo.add(opJava);
		grupo.add(opMotif);
		grupo.add(opMac);
		grupo.add(opSistema);

		getContentPane().add(panelOpciones);							
	}

	public void actionPerformed(ActionEvent evento){
		Object fuente=evento.getSource();
		String lf="";
		if (fuente==opWindows)
			lf="com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
		else if(fuente==opJava)
			lf="javax.swing.plaf.metal.MetalLookAndFeel";
		else if(fuente==opMotif)
			lf="com.sun.java.swing.plaf.motif.MotifLookAndFeel";
		else if(fuente==opMac)
			lf="javax.swing.plaf.mac.MacLookAndFeel";
		else if(fuente==opSistema)
			lf=UIManager.getSystemLookAndFeelClassName();
		try {
            	UIManager.setLookAndFeel(lf);
			SwingUtilities.updateComponentTreeUI(this);
			this.pack();
        	} catch (UnsupportedLookAndFeelException excepcion) {
				 texto.append("Look & Feel no soportado.\n"+excepcion+"\n");
		} catch (ClassNotFoundException excepcion){
				 texto.append("Clase no encontrada.\n"+excepcion+"\n");
		} catch (InstantiationException excepcion){
				 texto.append("Excepcin de instanciacin.\n"+excepcion+"\n");
		} catch(IllegalAccessException e){
				texto.append("Excepcin de acceso.\n"+e+"\n");
		}		
	}

	public void creaSelector(){
		selector=new JSlider(JSlider.HORIZONTAL,0,300,50);
		selector.setMajorTickSpacing(100);
		selector.setPaintTicks(true);
		selector.setPaintLabels(true);
		getContentPane().add(selector);
	}

	public void creaCombo(){
		listaOpciones=new JComboBox(opciones);
		listaOpciones.setSelectedIndex(0);
		getContentPane().add(listaOpciones);
	}
		
	public void creaEtiqueta(){
		etiqueta=new JLabel("Seleccione Look & Feel");
		etiqueta.setIcon(iconoIzq);
		etiqueta.setHorizontalTextPosition(JLabel.LEFT);
		etiqueta.setAlignmentX(Component.CENTER_ALIGNMENT);
		getContentPane().add(etiqueta);
	}

	public static void main(String s[]) {
		LF ventana = new LF();
		ventana.creaMenu();
		ventana.creaTexto();
		ventana.creaBotones();
		ventana.creaSelector();
		ventana.creaCombo();
		ventana.creaEtiqueta();
		ventana.creaOpciones();
		ventana.pack();
        	ventana.setVisible(true);
	}
}