#!/usr/bin/perl

# Example code from Chapter 1 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use strict;
use warnings;

use LWP::Simple;
use HTML::TokeParser;

my $html   = get("http://www.oreilly.com/") || die "Couldn't get it!";
my $stream = HTML::TokeParser->new(\$html);
my %image  = ();

while (my $token = $stream->get_token) {
    if ($token->[0] eq 'S' && $token->[1] eq 'img') {
        # store src value in %image
        $image{ $token->[2]{'src'} }++;
    }
}

foreach my $pic (sort keys %image) {
    print "$pic\n";
}
__END__

