#!/usr/bin/perl

# Example code from Chapter 1 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use strict;
use warnings;

use LWP::Simple;
use HTML::TreeBuilder;

my $html = get("http://www.oreilly.com/") || die "Couldn't get it!";
my $root = HTML::TreeBuilder->new_from_content($html);
my %images;
foreach my $node ($root->find_by_tag_name('img')) {
    $images{ $node->attr('src') }++;
}

foreach my $pic (sort keys %images) {
    print "$pic\n";
}
__END__

