#!/usr/bin/perl

# Example code from Chapter 2 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use strict;
use warnings;

my $lang;
if (@ARGV and $ARGV[0] =~ m/^-(\w\w)$/s) {
  # If the language is specified as a switch like "-fr"
  $lang = lc $1;
  shift @ARGV;
} else {
  # Otherwise just pick a language at random:
  my @languages = qw(it fr de es ja pt);
  # I.e.: Italian, French, German, Spanish, Japanese, Portugese.
  $lang = $languages[rand @languages];
}

die "What to translate?\n" unless @ARGV;
my $in = join(' ', @ARGV);

print " => via $lang => ",
  translate(
    translate($in, 'en_' . $lang),
    $lang . '_en'
  ), "\n";
exit;

sub translate {
  my ($text, $language_path) = @_;

  my ($content, $message, $is_success) = do_POST(
    'http://babelfish.altavista.com/translate.dyn',
    [ 'urltext' => $text, 'lp' => $language_path, 'enc' => 'utf8' ],
  );
  die "Error in translation $language_path: $message\n"
   unless $is_success;

  if ($content =~ m{<textarea.*?>(.*?)</textarea>}is) {
    my $translation;
    $translation = $1;
    # Trim whitespace:
    $translation =~ s/\s+/ /g;
    $translation =~ s/^ //s;
    $translation =~ s/ $//s;
    return $translation;
  } else {
    die "Can't find translation in response to $language_path";
  }
}

use LWP;
my $browser;
sub do_POST {
  # Parameters:
  #  the URL,
  #  an arrayref or hashref for the key/value pairs,
  #  and then, optionally, any header lines: (key,value, key,value)
  $browser = LWP::UserAgent->new() unless $browser;
  my $resp = $browser->post(@_);
  return ($resp->content, $resp->status_line, $resp->is_success, $resp)
    if wantarray;
  return unless $resp->is_success;
  return $resp->content;
}
__END__

C:\book\code\ch02>perl alienate.pl "It was more fun than a barrel of monkeys"
 => via it => It was more divertimento that a keg of the monkeys

C:\book\code\ch02>perl alienate.pl -de "Guess what! I'm a computer!"
 => via de => Assumption which! I am a computer!

