#!/usr/bin/perl

# Example code from Chapter 3 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use strict;
use warnings;

use LWP::UserAgent;
my $browser = LWP::UserAgent->new;
my $response = $browser->get('http://www.perl.com/images/tabs/tab-perlblk.gif',
  ':read_size_hint' => 123,
  ':content_cb' => sub {
    my($data, $resp) = @_;
    print length($data), " bytes:\n";
    print '  ', unpack('H*', substr($data,0,16,'')), "\n"
     while length $data;
    return;
  }
);


print "Waiting a bit...\n";
sleep 10;

my $age = $response->current_age();

my $days  = int($age/86400);       $age -= $days * 86400;
my $hours = int($age/3600);        $age -= $hours * 3600;
my $mins  = int($age/60);          $age -= $mins    * 60;
my $secs  = $age;
print "The document is $days days, $hours hours, $mins minutes, and $secs seconds old.\n";

  # Remember: "old" means how long since we got it!

__END__
C:\book\code\ch03>perl -w hexy_callback.pl
123 bytes:
  47494638396160001200d50000ffffff
  1818183939395252527b7b7b949494b5
  b5b5cececef7f7f7cea5a5ce009cce08
  9cce219cce5a9cce849c000000eeeeee
  eaeaeadededebcbcbcbababaaaaaaa9c
  9c9c9999998989897575756565655858
  585555554f4f4f444444363636303030
  2323232020201010100000
123 bytes:
  00000000000000000000000000000000
  00000000000000000000000000000000
  00000000000000000000000000000000
  00000000000000000000000000000000
  00000000000000000000000000000000
  00002c00000000600012000006f44080
  3062d9841ec8a472c96c3a9fd0a85419
  da5822c2eca433ed7abfe0
123 bytes:
  6967a2fd84cfe8b4f4438e70d5f0b8ba
  4394dbefdf227ecf6f1ae51e42121e0f
  14591e8600142381844a23170012200f
  1810121a0f81190f231214774780001e
  171285a048148b00198d4b19101a1c20
  1aad9122811023198a7d708dbda849ab
  22001aaf4a07174917079dc7ba9610a9
  bf68810710188559dcbec9
94 bytes:
  49adc4a9ad9b8aabd6699b94c3aa1419
  a7e048cbcdcf23d1a41488d5e960e0e8
  ee8c71d8e40184c107b13868a875ac57
  2e5222daf5f3478ad82174122a041242
  01c3364892225ac2a4a9a2c4892853aa
  5cc9b2a5cb973063ca6c1204003b
Waiting a bit...
The document is 0 days, 0 hours, 0 minutes, and 10 seconds old.

