#!/usr/bin/perl

# Example code from Chapter 5 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use strict;
use warnings;
use LWP; 
my $browser = LWP::UserAgent->new; 

my @searches = (  # outfile, author, title, first_edition 
  ['result_seraph.html',       '', 'Codex Seraphinianus', ''], 
  ['result_vidal_1green.html', 'Gore Vidal', 'Dark Green Bright Red', 1], 
  ['result_marchand.html',     'Hans Marchand', 'Categories', ''], 
  ['result_origins.html',      'Eric Partridge', 'Origins', ''], 
  ['result_navajo.html',       '', 'Navajo',   ''], 
  ['result_navaho.html',       '', 'Navaho',   ''], 
  ['result_iroq.html',         '', 'Iroquois', ''], 
  ['result_tibetan.html',      '', 'Tibetan',  ''], 
); 
do_stuff();

sub do_stuff { 
  foreach my $search (@searches) { 
    my $out_file = shift @$search; 
    my $resp = run_search(@$search);
    sleep 3; # Don't rudely query the ABEbooks server too fast! 
    process_search($resp, $out_file); 
  } 
}


sub run_search { 
  my($author, $title, $first_edition) = @_; 
  my $response = $browser->post( 
    'http://dogbert.abebooks.com/abe/BookSearch', 
    [ 
      "ph" => "2", 
      "an" => $author || "", 
      "tn" => $title  || "", 
      "pn" => "", 
      "sn" => "", 
      "gpnm" => "All Book Stores", 
      "cty" => "All Countries", 
      "bi" => "Any Binding", 
      $first_edition ? ("fe" => "on") : (), 
      "prl" => "", 
      "prh" => "", 
      "sortby" => "0", 
      "ds" => "100", 
      "bu" => "Start Search", 
    ] 
  ); 
  return $response; 
}

sub process_search { 
  my($response, $out_file) = @_; 
  die "Error: ", $response->status_line, "\n" 
   unless $response->is_success; 
  open(OUT, ">$out_file") || die "Can't write-open $out_file: $!"; 
  binmode(OUT); 
  print OUT $response->content; 
  close(OUT); 
  print "Bytes saved: ", -s $out_file, " in $out_file\n"; 
  return; 
}

__END__

