#!/usr/bin/perl

# formpairs.pl - extract names and values from HTTP requests

# Example code from Chapter 5 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use strict;
use warnings;

my $data; 
if(! $ENV{'REQUEST_METHOD'}) { # not run as a CGI 
  die "Usage: $0 \"url\"\n" unless $ARGV[0]; 
  $data = $ARGV[0]; 
  $data = $1 if $data =~ s/^\w+\:.*?\?(.+)//; 
  print "Data from that URL:\n(\n"; 
} elsif($ENV{'REQUEST_METHOD'} eq 'POST') { 
  read(STDIN, $data, $ENV{'CONTENT_LENGTH'}); 
  print "Content-type: text/plain\n\nPOST data:\n(\n"; 
} else { 
  $data = $ENV{'QUERY_STRING'}; 
  print "Content-type: text/plain\n\nGET data:\n(\n"; 
} 
for (split '&', $data, -1) {   # Assumes proper URLencoded input 
  tr/+/ /;   s/"/\\"/g;   s/=/\" => \"/;   s/%20/ /g; 
  s/%/\\x/g;  # so %0d => \x0d 
  print "  \"$_\",\n"; 
} 
print ")\n";
__END__


C:\book\code\ch05> perl formpairs.pl "http://www.google.com/search?q=%22horrible+horrible+freedom%22&btnG=Google+Search"
Data from that URL:
(
  "q" => "\x22horrible horrible freedom\x22",
  "btnG" => "Google Search",
)


