#!/usr/bin/perl

# Example code from Chapter 5 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use strict;
use warnings;

# gazetteer.pl -- query the US Cenus Gazetteer database

use URI; 
use LWP::UserAgent;

die "Usage: $0 \"That Town\"\n" unless @ARGV == 1; 
my $name = $ARGV[0]; 
my $url = URI->new('http://www.census.gov/cgi-bin/gazetteer'); 
$url->query_form( 'city' => $name, 'state' => '', 'zip' => ''); 
print $url, "\n"; 
 
my $response = LWP::UserAgent->new->get( $url ); 
die "Error: ", $response->status_line unless $response->is_success; 
extract_and_sort($response->content); 
 
sub extract_and_sort {  # A simple data extractor routine 
  die "No <ul>...</ul> in content" unless $_[0] =~ m{<ul>(.*?)</ul>}s; 
  my @pop_and_town; 
  foreach my $entry (split /<li>/, $1) { 
    next unless $entry =~ m{^<strong>(.*?)</strong>(.*?)<br>}s; 
    my $town = "$1 $2"; 
    next unless $entry =~ m{^Population \(.*?\): (\d+)<br>}m; 
    push @pop_and_town, sprintf "%10s %s\n", $1, $town; 
  } 
  print reverse sort @pop_and_town; 
}
__END__

C:\book\code\ch05>perl gazetteer.pl "Dulce"
http://www.census.gov/cgi-bin/gazetteer?city=Dulce&state=&zip=
      2438 Dulce, NM  (cdp)
       794 Agua Dulce, TX  (city)
       136 Guayabo Dulce Barrio, PR  (county subdivision)

