#!/usr/bin/perl

# Example code from Chapter 5 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

#
# NOTE: This program doesn't work anymore, because
#  the plates.ca.gov server has been retired.
#

require 5;
use strict;
use warnings;

use LWP::UserAgent; 
my $plate = $ARGV[0] || die "Plate to search for?\n"; 
$plate = uc $plate; 
$plate =~ tr/O/0/;  # we use zero for letter-oh 
die "$plate is invalid.\n" 
 unless $plate =~ m/^[A-Z0-9]{2,7}$/ 
    and $plate !~ m/^\d+$/;  # no all-digit plates 
 
my $browser = LWP::UserAgent->new; 
my $response = $browser->post( 
  'http://plates.ca.gov/search/search.php3', 
  [ 
    'plate'  => $plate, 
    'search' => 'Check Plate Availability' 
  ], 
); 
die "Error: ", $response->status_line 
 unless $response->is_success; 
 
if($response->content =~ m/is unavailable/) { 
  print "$plate is already taken.\n"; 
} elsif($response->content =~ m/and available/) { 
  print "$plate is AVAILABLE!\n"; 
} else { 
  print "$plate... Can't make sense of response?!\n"; 
} 
exit;
__END__

