#!/usr/bin/perl

# Example code from Chapter 6 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

# NOTE: This program has stopped working because
#  Weather Underground changed its output format.

require 5;
use strict;
use warnings;

use LWP::Simple;

my $url = "http://www.wunderground.com/cgi-bin/findweather/getForecast?"
        . "query=";
my $ca = get("${url}95472");
my $ma = get("${url}02140");

my $ca_temp = current_temp($ca);
my $ma_temp = current_temp($ma);
my $diff = $ca_temp - $ma_temp;

print $diff > 0 ? "CA" : "MA";
print " is warmer by ", abs($diff), " degrees F.\n";

sub current_temp {
  local $_ = shift;
  m{<tr ><td>Temperature</td>\s+<td><b>(\d+)}s
   or die "Couldn't find temperature data in this source: $_\n ";
  return $1;
}
__END__
