#!/usr/bin/perl

# Example code from Chapter 7 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use strict;
use warnings;

use LWP::Simple;
use HTML::TokeParser;
my $url = "http://news.bbc.co.uk/";
my $stream = HTML::TokeParser->new(
  \(get($url) || die "Can't get $url" )
);

while(my $token = $stream->get_token) {
  if($token->[0] eq 'S' and $token->[1] eq 'img') {
    my $i = $token->[2]; # attributes of this img tag
    my @lack = grep !exists $i->{$_}, qw(alt height width src);
    print "Missing for ", $i->{'src'} || "????", ": @lack\n" if @lack;
  }
}
__END__

