#!/usr/bin/perl

# Example code from Chapter 9 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use warnings;
use strict; 

use HTML::TreeBuilder 3;  # make sure our version isn't ancient 
use strict;

my $root = HTML::TreeBuilder->new_from_content(<<"EOHTML");
<b><i>Shatner wins Award!</i></b>
Today in <b>Hollywood</b> ...
<b><i>End of World Predicted!</i></b>
Today in <b>Washington</b> ...
EOHTML

$root->eof();

# print contents of <b><i>...</i></b>
my @bolds = $root->find_by_tag_name('b');
foreach my $node (@bolds) {
  my @kids = $node->content_list();
  if (@kids and ref $kids[0] and $kids[0]->tag() eq 'i') {
    print $kids[0]->as_text(), "\n";
  }
}

$root->delete;
exit;

__END__

Output:
Shatner wins Award!
End of World Predicted!

