#!/usr/bin/perl

# Example code from Chapter 9 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use warnings;
use strict; 

use HTML::TreeBuilder 3;  # make sure our version isn't ancient 

my $root = HTML::TreeBuilder->new; 
$root->parse(  # parse a string... 
q{ 
   <ul> 
     <li>Ice cream.</li> 
     <li>Whipped cream. 
     <li>Hot apple pie <br>(mmm pie)</li> 
   </ul> 
}); 
$root->eof();  # done parsing for this tree 
$root->dump;   # print() a representation of the tree 
$root->delete; # erase this tree because we're done with it

__END__

Output:
<html> @0 (IMPLICIT)
  <head> @0.0 (IMPLICIT)
  <body> @0.1 (IMPLICIT)
    <ul> @0.1.0
      <li> @0.1.0.0
        "Ice cream."
      <li> @0.1.0.1
        "Whipped cream. "
      <li> @0.1.0.2
        "Hot apple pie "
        <br> @0.1.0.2.1
        "(mmm pie)"


