#!/usr/bin/perl

# Example code from Chapter 10 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use warnings;
use strict; 
use HTML::TreeBuilder 3; 

my $root = HTML::TreeBuilder->new; 
$root->parse_file('rewriters1/in1.html') || die $!; 
 
print "Before:\n"; 
$root->dump; 
 
my @h3_center = $root->look_down('_tag', 'h3', 'align', 'center'); 
my @h3_red    = $root->look_down('_tag', 'h3', 'color', 'red'); 
foreach my $h3c (@h3_center) { 
  $h3c->attr('_tag', 'h2'); 
  $h3c->attr('style', 'scream'); 
  $h3c->attr('align', undef); 
} 

foreach my $h3r (@h3_red) { 
  $h3r->attr('_tag', 'h4'); 
  $h3r->attr('style', 'mumble'); 
  $h3r->attr('color', undef); 
}

print "\n\nAfter:\n"; 
$root->dump;

$root->delete; # done with it, so delete it

__END__
