#!/usr/bin/perl

# Example code from Chapter 10 of /Perl and LWP/ by Sean M. Burke
# http://www.oreilly.com/catalog/perllwp/
# sburke@cpan.org

require 5;
use warnings;
use strict; 
use HTML::TreeBuilder 3; 

my $root = HTML::TreeBuilder->new; 
$root->parse_file('rewriters1/in002.html') || die $!; 

my $good_td = $root->look_down( '_tag', 'td',  'class', 'story', ); 
die "No good td?!" unless $good_td;      # sanity checking 
my $big_table = $root->look_down( '_tag', 'table' ); 
die "No big table?!" unless $big_table;  # sanity checking

$good_td->detach; 
$big_table->replace_with($good_td); 
  # Yes, there's even a method for replacing one node with another!
 
open(OUT, ">rewriters1/out002b.html") || die "Can't write: $!"; 
print OUT $root->as_HTML(undef, '  '); # two-space indent in output 
close(OUT); 

$root->delete; # done with it, so delete it

__END__
