<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes"/>

  <xsl:template match="@*|node()">
    <xsl:apply-templates select="@*|node()"/>
  </xsl:template>
  <xsl:template match="/">
    <examples>
      <xsl:apply-templates select="@*|node()"/>
    </examples>
  </xsl:template>
  <xsl:template match="programlisting[preceding-sibling::*[1][self::para[text()[last()] = ':'][filename|emphasis]]]">
    <xsl:variable name="chaptitle" select="ancestor::chapter[1]/title"/>
    <xsl:variable name="chapnum">
      <xsl:number count="chapter" from="book" format="01" level="any"/>
    </xsl:variable>  
    <xsl:variable name="recipetitle" select="ancestor::sect1[1]/title"/>
    <xsl:variable name="recipenum">
      <xsl:number count="sect1" from="chapter" format="01" level="any"/>
    </xsl:variable>
    <xsl:variable name="filename" select="preceding-sibling::para[1]/*[last()]/text()"/>
    <xsl:message>
    <xsl:value-of select="$chapnum"/>-<xsl:value-of select="$recipenum"/>
    </xsl:message>
    <example>
      <chapname><xsl:value-of select="concat($chapnum, '_', $chaptitle)"/></chapname>
      <recipename><xsl:value-of select="concat($recipenum, '_', $recipetitle)"/></recipename>
      <filename><xsl:value-of select="$filename"/></filename>
      <text><xsl:value-of select="."/></text>
    </example>  
  </xsl:template>
</xsl:stylesheet>
