/*
 * Decompiled with CFR 0.152.
 */
package aggressor;

import common.AObject;
import common.Accent;
import common.CommonUtils;
import common.HasUUID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ui.ATable;
import ui.GenericTableModel;

public class TranscriptEditor
extends AObject {
    protected Map accents = new HashMap();
    protected Set removed = new HashSet();
    protected GenericTableModel model = null;
    protected ATable table = null;

    private static final boolean A(Accent accent) {
        return "remove".equals(accent.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoved(HasUUID hasUUID) {
        String string = hasUUID.ID();
        TranscriptEditor transcriptEditor = this;
        synchronized (transcriptEditor) {
            return this.removed.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map decorate(HasUUID hasUUID, Map map2) {
        String string = hasUUID.ID();
        TranscriptEditor transcriptEditor = this;
        synchronized (transcriptEditor) {
            if (!this.accents.containsKey(string)) {
                return map2;
            }
            map2.put("_accent", this.accents.get(string));
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTranscriptFormat(String string, Object object) {
        if (!"accents".equals(string)) {
            return false;
        }
        Accent accent = (Accent)object;
        TranscriptEditor transcriptEditor = this;
        synchronized (transcriptEditor) {
            if (TranscriptEditor.A(accent)) {
                this.removed.add(accent.getKey());
            } else {
                this.accents.put(accent.getKey(), accent.getValue());
            }
        }
        return true;
    }

    protected void remove(final String string) {
        if (this.table == null || this.model == null) {
            return;
        }
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                TranscriptEditor.this.table.markSelections();
                if (TranscriptEditor.this.model.removeRowWithValueAtColumn("id", string)) {
                    TranscriptEditor.this.model.fireListeners();
                    TranscriptEditor.this.table.restoreSelections();
                }
            }
        });
    }

    protected void setAccent(final String string, final String string2) {
        if (this.table == null || this.model == null) {
            return;
        }
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                TranscriptEditor.this.table.markSelections();
                if (TranscriptEditor.this.model.setValueForKeyAtColumn("id", string, "_accent", string2)) {
                    TranscriptEditor.this.model.fireListeners();
                    TranscriptEditor.this.table.restoreSelections();
                }
            }
        });
    }

    public void setTable(ATable aTable, GenericTableModel genericTableModel) {
        this.table = aTable;
        this.model = genericTableModel;
    }

    public boolean processTranscriptResult(String string, Object object) {
        if (!"accents".equals(string)) {
            return false;
        }
        this.processTranscriptFormat(string, object);
        Accent accent = (Accent)object;
        if (TranscriptEditor.A(accent)) {
            this.remove(accent.getKey());
        } else {
            this.setAccent(accent.getKey(), accent.getValue());
        }
        return true;
    }
}

