/*
 * Decompiled with CFR 0.152.
 */
package aggressor.browsers;

import aggressor.AggressorClient;
import aggressor.ColorManager;
import common.AObject;
import common.AdjustData;
import common.CommonUtils;
import dialog.DialogUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.table.TableModel;
import sleep.runtime.Scalar;
import ui.ATable;
import ui.GenericTableModel;
import ui.QueryRows;
import ui.TablePopup;

public class Services
extends AObject
implements AdjustData,
TablePopup,
QueryRows {
    protected AggressorClient client = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"address", "port", "banner", "note"};
    protected Set targets = null;

    public Services(AggressorClient aggressorClient, String[] stringArray) {
        this.client = aggressorClient;
        this.targets = CommonUtils.toSet(stringArray);
    }

    public ActionListener cleanup() {
        return this.client.getData().unsubOnClose("services", this);
    }

    @Override
    public Map format(String string, Object object) {
        Map map2 = (Map)object;
        if (this.targets.contains(map2.get("address"))) {
            return map2;
        }
        return null;
    }

    public JComponent getContent() {
        LinkedList linkedList = this.client.getData().populateListAndSubscribe("services", this);
        this.model = DialogUtils.setupModel("address", this.cols, linkedList);
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        DialogUtils.sortby(this.table, 1);
        this.table.setPopupMenu(this);
        Map map2 = DialogUtils.toMap("address: 125, port: 60, banner: 250, note: 250");
        DialogUtils.setTableColumnWidths(this.table, map2);
        return DialogUtils.FilterAndScroll(this.table);
    }

    @Override
    public Map[] getSelectedRows() {
        return this.model.getSelectedRows(this.table);
    }

    @Override
    public void showPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Set set = CommonUtils.toSet(this.model.getSelectedValues(this.table));
        Object[] objectArray = CommonUtils.toArray(set);
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(CommonUtils.toSleepArray(objectArray));
        this.client.getScriptEngine().getMenuBuilder().setupMenu(jPopupMenu, "targets", stack);
        JMenu jMenu = new JMenu("Color (Service)");
        jMenu.add(new ColorManager(this.client, this, "services").getColorPanel());
        jPopupMenu.add(jMenu);
        jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    public boolean hasSelectedRows() {
        return this.model.hasSelectedRows(this.table);
    }

    @Override
    public void result(String string, Object object) {
        DialogUtils.setTable(this.table, this.model, CommonUtils.apply(string, (List)object, this));
    }
}

