/*
 * Decompiled with CFR 0.152.
 */
package aggressor.browsers;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import common.AObject;
import common.Callback;
import dialog.DialogUtils;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import ui.ATable;
import ui.DoubleClickListener;
import ui.DoubleClickWatch;
import ui.GenericTableModel;
import ui.TablePopup;

public class Sessions
extends AObject
implements Callback,
TablePopup,
DoubleClickListener {
    protected AggressorClient client = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{" ", "external", "internal", "listener", "user", "computer", "note", "process", "pid", "arch", "last", "sleep"};
    protected boolean multipleSelect;

    public ATable getTable() {
        return this.table;
    }

    public void setColumns(String[] stringArray) {
        this.cols = stringArray;
    }

    public Sessions(AggressorClient aggressorClient, boolean bl) {
        this.client = aggressorClient;
        this.multipleSelect = bl;
    }

    public ActionListener cleanup() {
        return this.client.getData().unsubOnClose("beacons", this);
    }

    public WindowListener onclose() {
        return this.client.getData().unsubOnClose("beacons", this);
    }

    @Override
    public void doubleClicked(MouseEvent mouseEvent) {
        String string = (String)this.model.getSelectedValue(this.table);
        DialogUtils.openOrActivate(this.client, string);
    }

    public boolean hasSelectedRows() {
        return this.model.hasSelectedRows(this.table);
    }

    public Object[] getSelectedValues() {
        return this.model.getSelectedValues(this.table);
    }

    public Object getSelectedValue() {
        return this.model.getSelectedValue(this.table) + "";
    }

    @Override
    public void showPopup(MouseEvent mouseEvent) {
        DialogUtils.showSessionPopup(this.client, mouseEvent, this.model.getSelectedValues(this.table));
    }

    public JComponent getContent() {
        this.model = this.cols.length == 12 ? DialogUtils.setupModel("id", this.cols, DataUtils.getBeaconModel(this.client.getData())) : DialogUtils.setupModel("id", this.cols, DataUtils.getBeaconModel(this.client.getData()));
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, this.multipleSelect);
        if (this.cols.length == 12) {
            DialogUtils.sortby(this.table, 2, 8);
            this.table.getColumn("arch").setPreferredWidth(96);
        } else {
            DialogUtils.sortby(this.table, 1);
        }
        this.table.getColumn(" ").setPreferredWidth(32);
        this.table.getColumn(" ").setMaxWidth(32);
        this.table.getColumn("pid").setPreferredWidth(96);
        this.table.getColumn("last").setPreferredWidth(110);
        this.table.getColumn("sleep").setPreferredWidth(190);
        DialogUtils.setupImageRenderer(this.table, this.model, " ", "image");
        DialogUtils.setupLastRenderer(this.table, this.model, "last");
        DialogUtils.setupSleepRenderer(this.table, "sleep");
        DialogUtils.setupUserRenderer(this.table, this.model, "user");
        this.table.setPopupMenu(this);
        this.table.addMouseListener(new DoubleClickWatch(this));
        this.client.getData().subscribe("beacons", this);
        return DialogUtils.FilterAndScroll(this.table);
    }

    @Override
    public void result(String string, Object object) {
        if (!this.table.isShowing()) {
            return;
        }
        DialogUtils.setTable(this.table, this.model, DataUtils.getBeaconModelFromResult(object));
    }
}

