/*
 * Decompiled with CFR 0.152.
 */
package aggressor.browsers;

import aggressor.AggressorClient;
import common.AObject;
import common.AdjustData;
import common.BeaconEntry;
import common.CHECKINSTATE;
import common.CommonUtils;
import dialog.ActivityPanel;
import dialog.DialogUtils;
import dialog.SafeDialogs;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import sleep.runtime.Scalar;
import ui.ATable;
import ui.GenericTableModel;
import ui.QueryRows;
import ui.TablePopup;

public class Targets
extends AObject
implements AdjustData,
TablePopup,
QueryRows {
    protected AggressorClient client = null;
    protected ActivityPanel dialog = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{" ", "address", "name", "note"};
    protected LinkedList targets = new LinkedList();
    protected Set compromised = new HashSet();

    public Targets(AggressorClient aggressorClient) {
        SafeDialogs.SafetyCheck.checkSafety(this.getClass());
        this.client = aggressorClient;
    }

    public ATable getTable() {
        return this.table;
    }

    public ActionListener cleanup() {
        return this.client.getData().unsubOnClose("targets, beacons", this);
    }

    @Override
    public Map format(String string, Object object) {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>((Map)object);
        boolean bl = this.compromised.contains((String)hashMap.get("address"));
        ImageIcon imageIcon = DialogUtils.TargetVisualizationSmall(hashMap.get("os") + "", CommonUtils.toDoubleNumber(hashMap.get("version") + "", 0.0), bl, CHECKINSTATE.GOOD);
        hashMap.put("image", imageIcon);
        hashMap.put("owned", bl ? Boolean.TRUE : Boolean.FALSE);
        return hashMap;
    }

    public JComponent getContent() {
        this.client.getData().subscribe("beacons", this);
        this.targets = this.client.getData().populateListAndSubscribe("targets", this);
        this.model = DialogUtils.setupModel("address", this.cols, this.targets);
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        this.table.setPopupMenu(this);
        DialogUtils.sortby(this.table, 1);
        Map map2 = DialogUtils.toMap("address: 125, name: 125, note: 625");
        DialogUtils.setTableColumnWidths(this.table, map2);
        this.table.getColumn(" ").setPreferredWidth(32);
        this.table.getColumn(" ").setMaxWidth(32);
        DialogUtils.setupImageRenderer(this.table, this.model, " ", "image");
        DialogUtils.setupBoldOnKeyRenderer(this.table, this.model, "address", "owned");
        DialogUtils.setupBoldOnKeyRenderer(this.table, this.model, "name", "owned");
        DialogUtils.setupBoldOnKeyRenderer(this.table, this.model, "note", "owned");
        return DialogUtils.FilterAndScroll(this.table);
    }

    @Override
    public Map[] getSelectedRows() {
        return this.model.getSelectedRows(this.table);
    }

    @Override
    public void showPopup(MouseEvent mouseEvent) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(CommonUtils.toSleepArray(this.model.getSelectedValues(this.table)));
        this.client.getScriptEngine().getMenuBuilder().installMenu(mouseEvent, "targets", stack);
    }

    public void refresh() {
        this.targets = CommonUtils.apply("targets", this.targets, this);
        DialogUtils.setTable(this.table, this.model, this.targets);
    }

    @Override
    public void result(String string, Object object) {
        if ("targets".equals(string)) {
            this.targets = new LinkedList((LinkedList)object);
            this.refresh();
            if (this.dialog != null) {
                this.dialog.touch();
            }
        } else if ("beacons".equals(string)) {
            HashSet<String> hashSet = new HashSet<String>();
            for (BeaconEntry beaconEntry : ((Map)object).values()) {
                if (!beaconEntry.isActive()) continue;
                hashSet.add(beaconEntry.getInternal());
            }
            if (!hashSet.equals(this.compromised)) {
                this.compromised = hashSet;
                this.refresh();
            }
        }
    }

    public boolean hasSelectedRows() {
        return this.model.hasSelectedRows(this.table);
    }

    public void notifyOnResult(ActivityPanel activityPanel) {
        this.dialog = activityPanel;
    }
}

