/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import common.CommonUtils;
import common.Keys;
import data.DataAggregate;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;

public class ExportDataDialog
implements DialogListener,
SafeDialogCallback,
Runnable {
    protected AggressorClient client;
    protected String file;
    protected String output;

    public ExportDataDialog(AggressorClient aggressorClient) {
        this.client = aggressorClient;
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        this.output = DialogUtils.string(map2, "output");
        SafeDialogs.openFile("Save to...", null, null, false, true, this);
    }

    @Override
    public void dialogResult(String string) {
        this.file = string;
        new File(string).mkdirs();
        new Thread((Runnable)this, "export " + string).start();
    }

    public void dump(List list, String string, String[] stringArray) {
        if ("XML".equals(this.output)) {
            this.dumpXML(list, string, stringArray);
        } else {
            this.dumpTSV(list, string, stringArray);
        }
    }

    public void dumpXML(List list, String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<" + string + ">\n");
        for (Map map2 : list) {
            stringBuffer.append("\t<entry>\n");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("\t\t\t<" + stringArray[i] + ">");
                stringBuffer.append(DialogUtils.string(map2, stringArray[i]));
                stringBuffer.append("</" + stringArray[i] + ">\n");
            }
            stringBuffer.append("\t</entry>\n");
        }
        stringBuffer.append("</" + string + ">\n");
        CommonUtils.writeToFile(new File(this.file, string + ".xml"), CommonUtils.toBytes(stringBuffer.toString(), "UTF-8"));
    }

    public void dumpTSV(List list, String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        for (Map map2 : list) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(DialogUtils.string(map2, stringArray[i]));
                if (i + 1 >= stringArray.length) continue;
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
        }
        CommonUtils.writeToFile(new File(this.file, string + ".tsv"), CommonUtils.toBytes(stringBuffer.toString(), "UTF-8"));
    }

    public static List getKey(List list, String string) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        for (Map map2 : list) {
            String string2 = DialogUtils.string(map2, "type");
            if (!string2.equals(string)) continue;
            linkedList.add(map2);
        }
        return linkedList;
    }

    public static List getBeaconStuff(List list) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        for (Map map2 : list) {
            String string = DialogUtils.string(map2, "type");
            if (!string.equals("checkin") && !string.equals("input") && !string.equals("output") && !string.equals("indicator") && !string.equals("task") && !string.equals("beacon_initial")) continue;
            linkedList.add(map2);
        }
        return linkedList;
    }

    @Override
    public void run() {
        ProgressMonitor progressMonitor = new ProgressMonitor(this.client, "Export Data", "Starting...", 0, 6 + Keys.size());
        int n = 0;
        progressMonitor.setNote("Aggregate data...");
        Map map2 = DataAggregate.AllModels(this.client);
        progressMonitor.setProgress(1);
        ++n;
        progressMonitor.setNote("webhits");
        this.dump(ExportDataDialog.getKey((List)map2.get("archives"), "webhit"), "webhits", CommonUtils.toArray("when, token, data"));
        progressMonitor.setProgress(2);
        ++n;
        progressMonitor.setNote("campaigns");
        this.dump(ExportDataDialog.getKey((List)map2.get("archives"), "sendmail_start"), "campaigns", CommonUtils.toArray("cid, when, url, attachment, template, subject"));
        progressMonitor.setProgress(3);
        ++n;
        progressMonitor.setNote("sentemails");
        this.dump(ExportDataDialog.getKey((List)map2.get("archives"), "sendmail_post"), "sentemails", CommonUtils.toArray("token, cid, when, status, data"));
        progressMonitor.setProgress(4);
        ++n;
        progressMonitor.setNote("activity");
        this.dump(ExportDataDialog.getBeaconStuff((List)map2.get("archives")), "activity", CommonUtils.toArray("bid, type, when, data, tactic"));
        progressMonitor.setProgress(5);
        ++n;
        progressMonitor.setNote("events");
        this.dump(ExportDataDialog.getKey((List)map2.get("archives"), "notify"), "events", CommonUtils.toArray("when, data"));
        progressMonitor.setProgress(6);
        ++n;
        Iterator iterator = Keys.getDataModelIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            progressMonitor.setNote(string);
            this.dump((List)map2.get(string), string, Keys.getCols(string));
            progressMonitor.setProgress(n);
            ++n;
        }
        progressMonitor.close();
        DialogUtils.showInfo("Exported data to " + this.file);
    }

    public void show() {
        JFrame jFrame = DialogUtils.dialog("Export Data", 640, 480);
        DialogManager dialogManager = new DialogManager(jFrame);
        dialogManager.addDialogListener(this);
        dialogManager.combobox("output", "Output:", CommonUtils.toArray("TSV, XML"));
        JButton jButton = dialogManager.action("Export");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-export-data");
        jFrame.add((Component)dialogManager.layout(), "Center");
        jFrame.add((Component)DialogUtils.center(jButton, jButton2), "South");
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

