/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import common.CommonUtils;
import data.DataAggregate;
import data.FieldSorter;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;
import report.Document;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;
import ui.Sorters;

public class ExportReportDialog
implements DialogListener,
SafeDialogCallback,
Runnable {
    protected AggressorClient client;
    protected String report;
    protected Map options;
    protected String file;

    public ExportReportDialog(AggressorClient aggressorClient, String string) {
        this.client = aggressorClient;
        this.report = string;
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        this.options = map2;
        String string = DialogUtils.string(map2, "output");
        String string2 = CommonUtils.strrep(this.report.toLowerCase(), " ", "");
        string2 = CommonUtils.strrep(string2, "&", "_");
        string2 = CommonUtils.strrep(string2, ",", "");
        if ("PDF".equals(string)) {
            string2 = string2 + ".pdf";
        } else if ("MS Word".equals(string)) {
            string2 = string2 + ".docx";
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        for (String string3 : list) {
            if (string3 == null || !string3.toLowerCase().contains("-javaagent:")) continue;
            System.exit(0);
        }
        SafeDialogs.saveFile(null, string2, this);
    }

    @Override
    public void dialogResult(String string) {
        this.file = string;
        new Thread((Runnable)this, "export " + string).start();
    }

    public void sort(Map map2, String string, String string2, Comparator comparator) {
        List list = (List)map2.get(string);
        if (list == null) {
            CommonUtils.print_error("Model '" + string + "' doesn't exist. Can't sort by: '" + string2 + "'");
            Thread.currentThread();
            Thread.dumpStack();
        } else {
            Collections.sort(list, new FieldSorter(string2, comparator));
        }
    }

    public void mask(Map map2, String string, String string2) {
        List list = (List)map2.get(string);
        for (Map map3 : list) {
            String string3 = DialogUtils.string(map3, string2);
            if (string3.length() == 32) {
                map3.put(string2, string3.replaceAll(".", "*"));
                continue;
            }
            map3.put(string2, "********");
        }
    }

    public void maskemail(Map map2, String string, String string2) {
        List list = (List)map2.get(string);
        for (Map map3 : list) {
            String string3 = DialogUtils.string(map3, string2);
            if (string3 == null) continue;
            String[] stringArray = string3.split("@");
            map3.put(string2, CommonUtils.garbage(stringArray[0]) + "@" + stringArray[1]);
        }
    }

    @Override
    public void run() {
        String string = DialogUtils.string(this.options, "output");
        String string2 = DialogUtils.string(this.options, "short");
        String string3 = DialogUtils.string(this.options, "long");
        String string4 = DialogUtils.string(this.options, "description");
        boolean bl = DialogUtils.bool(this.options, "mask");
        ProgressMonitor progressMonitor = new ProgressMonitor(this.client, "Export Report", "Starting...", 0, 5);
        progressMonitor.setNote("Aggregate data...");
        Map map2 = DataAggregate.AllModels(this.client);
        progressMonitor.setProgress(1);
        progressMonitor.setNote("Sort targets");
        this.sort(map2, "targets", "address", Sorters.getHostSorter());
        progressMonitor.setNote("Sort services");
        this.sort(map2, "services", "port", Sorters.getNumberSorter());
        progressMonitor.setNote("Sort credentials");
        this.sort(map2, "credentials", "password", Sorters.getStringSorter());
        this.sort(map2, "credentials", "realm", Sorters.getStringSorter());
        this.sort(map2, "credentials", "user", Sorters.getNumberSorter());
        progressMonitor.setNote("Sort applications");
        this.sort(map2, "applications", "application", Sorters.getStringSorter());
        progressMonitor.setNote("Sort sessions");
        this.sort(map2, "sessions", "opened", Sorters.getNumberSorter());
        progressMonitor.setNote("Sort archives");
        this.sort(map2, "archives", "when", Sorters.getNumberSorter());
        progressMonitor.setProgress(2);
        if (bl) {
            this.mask(map2, "credentials", "password");
            this.maskemail(map2, "tokens", "email");
        }
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(map2));
        stack.push(CommonUtils.convertAll(map2));
        stack.push(CommonUtils.convertAll(this.options));
        progressMonitor.setNote("Build document...");
        Document document = this.client.getReportEngine().buildReport(this.report, string2, stack);
        progressMonitor.setProgress(3);
        progressMonitor.setNote("Export document...");
        if ("PDF".equals(string)) {
            document.toPDF(new File(this.file));
        } else if ("MS Word".equals(string)) {
            document.toWord(new File(this.file));
        }
        progressMonitor.setProgress(4);
        progressMonitor.close();
        DialogUtils.showInfo("Report " + this.file + " saved");
    }

    public void show() {
        JFrame jFrame = DialogUtils.dialog("Export Report", 640, 480);
        DialogManager dialogManager = new DialogManager(jFrame);
        dialogManager.addDialogListener(this);
        dialogManager.set("output", "PDF");
        dialogManager.set("short", this.report);
        dialogManager.set("long", this.report);
        dialogManager.set("description", this.client.getReportEngine().describe(this.report));
        dialogManager.text("short", "Short Title:", 20);
        dialogManager.text("long", "Long Title:", 20);
        dialogManager.text_big("description", "Description:");
        dialogManager.combobox("output", "Output:", CommonUtils.toArray("MS Word, PDF"));
        JComponent jComponent = dialogManager.layout();
        JCheckBox jCheckBox = dialogManager.checkbox("mask", "Mask email addresses and passwords");
        JButton jButton = dialogManager.action("Export");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-reporting");
        jFrame.add((Component)DialogUtils.stack(jComponent, jCheckBox), "Center");
        jFrame.add((Component)DialogUtils.center(jButton, jButton2), "South");
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

