/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import common.AObject;
import common.Guardrails;
import common.ListenerUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;

public class GuardrailsDialog
extends AObject
implements DialogListener {
    protected JFrame dialog = null;
    protected SafeDialogCallback callback = null;
    protected String tabbedGuards;

    public GuardrailsDialog(String string, SafeDialogCallback safeDialogCallback) {
        this.callback = safeDialogCallback;
        this.tabbedGuards = string;
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        if ("Reset".equals(actionEvent.getActionCommand())) {
            this.callback.dialogResult("");
        } else if ("Set".equals(actionEvent.getActionCommand())) {
            if (!ListenerUtils.checkGuardrails(map2)) {
                return;
            }
            Guardrails guardrails = Guardrails.resolveFromProps(map2);
            this.callback.dialogResult(guardrails.toTabDelString());
            DialogUtils.close(this.dialog);
        }
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Guardrail Settings", 320, 240);
        this.dialog.setLayout(new BorderLayout());
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        Guardrails guardrails = Guardrails.parseTabDelString(this.tabbedGuards);
        dialogManager.set(guardrails.toPropsMap());
        dialogManager.text("props_guardip", "IP Address:", 20);
        dialogManager.text("props_guarduser", "User Name: ", 20);
        dialogManager.text("props_guardserver", "Server Name: ", 20);
        dialogManager.text("props_guarddomain", "Domain: ", 20);
        JButton jButton = dialogManager.action_noclose("Set");
        JButton jButton2 = dialogManager.action("Reset");
        JButton jButton3 = dialogManager.help("https://www.cobaltstrike.com/help-http-beacon#guardrails");
        this.dialog.add((Component)dialogManager.layout(), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2, jButton3), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
        this.dialog.show();
    }
}

