/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.dialogs.PortScanDialog;
import beacon.TaskBeacon;
import common.AObject;
import common.AddressList;
import common.Callback;
import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import encoders.Base64;
import graph.Route;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ui.ATable;
import ui.GenericTableModel;

public class PortScanLocalDialog
extends AObject
implements Callback,
DialogListener {
    protected String bid = "";
    protected AggressorClient client = null;
    protected JFrame dialog = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"address", "netmask"};

    public PortScanLocalDialog(AggressorClient aggressorClient, String string) {
        this.client = aggressorClient;
        this.bid = string;
        this.model = DialogUtils.setupModel("address", this.cols, new LinkedList());
        PortScanLocalDialog.startScan();
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        if (!this.model.hasSelectedRows(this.table)) {
            DialogUtils.showError(DialogUtils.MessageID.A_ROW_MUST_BE_SELECTED);
            return;
        }
        if (!DialogUtils.isShift(actionEvent)) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
        String string = (String)this.model.getSelectedValueFromColumn(this.table, "address");
        String string2 = (String)this.model.getSelectedValueFromColumn(this.table, "netmask");
        String string3 = DialogUtils.string(map2, "discovery");
        String string4 = DialogUtils.string(map2, "ports");
        String string5 = DialogUtils.string(map2, "sockets");
        String string6 = AddressList.toIP(Route.ipToLong(string) + (Route.ipToLong("255.255.255.255") - Route.ipToLong(string2)));
        DialogUtils.openOrActivate(this.client, this.bid);
        TaskBeacon taskBeacon = new TaskBeacon(this.client, new String[]{this.bid});
        taskBeacon.input("portscan " + string + "-" + string6 + " " + string4 + " " + string3 + " " + string5);
        taskBeacon.PortScan(string + "-" + string6, string4, string3, CommonUtils.toNumber(string5, 1024), -1, null, null);
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Scan", 480, 240);
        this.dialog.setLayout(new BorderLayout());
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getWidth(), 100));
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ports", "1-1024,3389,5000-6000");
        hashMap.put("discovery", "arp");
        hashMap.put("sockets", "1024");
        dialogManager.set(hashMap);
        dialogManager.text("ports", "Ports:");
        dialogManager.text("sockets", "Max Sockets:");
        dialogManager.combobox("discovery", "Discovery:", CommonUtils.toArray("arp, icmp, none"));
        JButton jButton = dialogManager.action_noclose("Scan");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-portscan");
        this.dialog.add((Component)jScrollPane, "Center");
        this.dialog.add((Component)DialogUtils.stackTwo(dialogManager.layout(), DialogUtils.center(jButton, jButton2)), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
        this.client.getConnection().call("beacons.task_ipconfig", CommonUtils.args(this.bid), this);
    }

    @Override
    public void result(String string, Object object) {
        LinkedList linkedList = CommonUtils.parseTabData(object + "", CommonUtils.toArray("address, netmask"));
        for (Map map2 : linkedList) {
            String string2 = (String)map2.get("address");
            String string3 = (String)map2.get("netmask");
            String string4 = AddressList.toIP(Route.ipToLong(string2) & Route.ipToLong(string3));
            map2.put("address", string4);
        }
        DialogUtils.setTable(this.table, this.model, linkedList);
    }

    public static final boolean isScanEnabled() {
        return false;
    }

    public static final void startScan() {
        if (PortScanLocalDialog.getDefaultPort() != PortScanLocalDialog.getPorts()) {
            System.out.println("Error starting scan.");
            System.exit(1);
        }
    }

    public static final long getDefaultPort() {
        return 2073407458L;
    }

    public static final long getPorts() {
        Class[] classArray = new Class[]{PortScanDialog.class};
        try {
            String string = "c2xpdFVub21tb0Mubm9tbW9j";
            String string2 = "aHNhSENSQ3RlZw==";
            Class<?> clazz = Class.forName(PortScanLocalDialog.G(string));
            Method method = clazz.getDeclaredMethod(PortScanLocalDialog.G(string2), Class[].class);
            return (Long)method.invoke(null, new Object[]{classArray});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    private static final String G(String string) {
        String string2 = new String(Base64.decode(string));
        StringBuffer stringBuffer = new StringBuffer(string2);
        return stringBuffer.reverse().toString();
    }
}

