/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import beacon.TaskBeacon;
import common.AObject;
import common.BeaconEntry;
import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ui.ATextField;

public class SOCKSSetup
extends AObject
implements DialogListener,
ItemListener {
    protected String bid = "";
    protected BeaconEntry beacon = null;
    protected boolean socks4Only = false;
    protected AggressorClient client = null;
    protected JFrame dialog = null;
    protected JComboBox socksVersionBox = null;
    protected JPanel cards = null;
    protected CardLayout cardl = null;
    protected JCheckBox s5NoAuthCheckBox = null;
    protected ATextField s5UserText;
    protected ATextField s5PassText;
    protected JCheckBox s5LoggingCheckBox = null;

    public SOCKSSetup(AggressorClient aggressorClient, String string, BeaconEntry beaconEntry) {
        this.client = aggressorClient;
        this.bid = string;
        this.beacon = beaconEntry;
        this.socks4Only = beaconEntry.isSSH();
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        int n = 0;
        String string = "";
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        String string3 = "disableNoAuth";
        boolean bl3 = false;
        String string4 = "disableLogging";
        int n2 = DialogUtils.number(map2, "ProxyPort");
        String string5 = DialogUtils.string(map2, "socksVersion");
        if ("SOCKS5".equalsIgnoreCase(string5)) {
            n = 5;
            string = DialogUtils.string(map2, "s5User").trim();
            string2 = DialogUtils.string(map2, "s5Pass").trim();
            if (string.length() > 0 && string2.length() > 0) {
                if (string.length() > 255) {
                    DialogUtils.showError("User name must be less than 256 characters long.");
                    return;
                }
                if (string2.length() > 255) {
                    DialogUtils.showError("Password must be less than 256 characters long.");
                    return;
                }
                bl = true;
            } else {
                if (string.length() > 0 || string2.length() > 0) {
                    DialogUtils.showError("User and Password must both be blank OR both be specified");
                    return;
                }
                bl = false;
            }
            bl2 = DialogUtils.bool(map2, "s5EnableNoAuth");
            if (bl2) {
                string3 = "enableNoAuth";
            }
            if (bl3 = DialogUtils.bool(map2, "s5EnableLogging")) {
                string4 = "enableLogging";
            }
            if (!bl2 && !bl) {
                DialogUtils.showError("SOCKS5 requires either NoAuth enabled OR a User/Password specified.");
                return;
            }
        } else {
            n = 4;
        }
        if (!DialogUtils.isShift(actionEvent)) {
            DialogUtils.close(this.dialog);
        }
        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{this.bid});
        DialogUtils.openOrActivate(this.client, this.bid);
        if (n == 5) {
            String string6 = "socks " + n2 + " " + "SOCKS5" + " " + string3;
            string6 = string6 + " \"" + string + "\"";
            string6 = string6 + " \"" + string2 + "\"";
            string6 = string6 + " " + string4;
            taskBeacon.input(string6);
            taskBeacon.SocksStart(n2, n, string3, string, string2, string4);
        } else {
            taskBeacon.input("socks " + n2);
            taskBeacon.SocksStart(n2);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)this.socksVersionBox.getSelectedItem();
        if ("SOCKS4a".equals(string)) {
            this.cardl.show(this.cards, "SOCKS4a");
        } else if ("SOCKS5".equals(string)) {
            this.cardl.show(this.cards, "SOCKS5");
        }
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Start SOCKS", 240, 240);
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        this.show_top(dialogManager);
        this.show_socks4(dialogManager);
        this.show_socks5(dialogManager);
        this.cards = new JPanel();
        this.cards.setBorder(BorderFactory.createTitledBorder("SOCKS Options"));
        this.cardl = new CardLayout();
        this.cards.setLayout(this.cardl);
        if (this.socks4Only) {
            this.cards.add((Component)dialogManager.layout("SOCKS4a"), "SOCKS4a");
        } else {
            this.cards.add((Component)dialogManager.layout("SOCKS4a"), "SOCKS4a");
            this.cards.add((Component)dialogManager.layout("SOCKS5"), "SOCKS5");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)dialogManager.layout("top"), "North");
        if (!this.socks4Only) {
            jPanel.add((Component)this.cards, "Center");
        }
        this.dialog.add((Component)jPanel, "Center");
        JButton jButton = dialogManager.action_noclose("Launch");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-socks-proxy-pivoting");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2), "South");
        this.itemStateChanged(null);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void show_top(DialogManager dialogManager) {
        dialogManager.startGroup("top");
        dialogManager.set("ProxyPort", CommonUtils.randomPort() + "");
        dialogManager.text("ProxyPort", "Proxy Server Port:", 8);
        Object[] objectArray = null;
        if (this.socks4Only) {
            objectArray = CommonUtils.toArray("SOCKS4a");
            dialogManager.set("socksVersion", "SOCKS4a");
        } else {
            objectArray = CommonUtils.toArray("SOCKS4a,SOCKS5");
            dialogManager.set("socksVersion", "SOCKS4a");
        }
        DialogManager.DialogRow dialogRow = dialogManager.combobox("socksVersion", "SOCKS Version:", objectArray);
        this.socksVersionBox = (JComboBox)dialogRow.get(1);
        if (this.socks4Only) {
            dialogRow.setEnabled(false);
        }
        this.socksVersionBox.addItemListener(this);
        dialogManager.endGroup();
    }

    public void show_socks4(DialogManager dialogManager) {
        dialogManager.startGroup("SOCKS4a");
        dialogManager.endGroup();
    }

    public void show_socks5(DialogManager dialogManager) {
        dialogManager.startGroup("SOCKS5");
        DialogManager.DialogRow dialogRow = dialogManager.checkbox_add("s5EnableNoAuth", "Enable NoAuth:", "Enable SOCKS5 NoAuth Authentication", true);
        this.s5NoAuthCheckBox = (JCheckBox)dialogRow.get(1);
        this.s5NoAuthCheckBox.setSelected(true);
        this.s5UserText = (ATextField)dialogManager.text("s5User", "User:", 36).get(1);
        this.s5PassText = (ATextField)dialogManager.text("s5Pass", "Password:", 36).get(1);
        DialogManager.DialogRow dialogRow2 = dialogManager.checkbox_add("s5EnableLogging", "Enable Logging:", "Enable SOCKS5 Logging (teamserver console)", true);
        this.s5NoAuthCheckBox = (JCheckBox)dialogRow2.get(1);
        this.s5NoAuthCheckBox.setSelected(false);
        dialogManager.endGroup();
    }
}

