/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import aggressor.browsers.Credentials;
import beacon.TaskBeacon;
import common.BeaconEntry;
import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ui.ATextField;

public class SecureShellDialog
implements DialogListener,
ListSelectionListener {
    protected JFrame dialog = null;
    protected AggressorClient client = null;
    protected ATextField user;
    protected ATextField pass;
    protected ATextField port;
    protected Credentials browser;
    protected String[] targets;
    protected JCheckBox b;

    public SecureShellDialog(AggressorClient aggressorClient, String[] stringArray) {
        this.client = aggressorClient;
        this.browser = new Credentials(aggressorClient);
        this.targets = stringArray;
        this.browser.setColumns("user, password, realm, note");
        this.browser.noHashes();
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        String string = DialogUtils.string(map2, "bid");
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string);
        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{string});
        String string2 = DialogUtils.string(map2, "user");
        String string3 = DialogUtils.string(map2, "pass");
        String string4 = DialogUtils.string(map2, "port");
        if ("".equals(string2)) {
            DialogUtils.showError("You must specify a user");
            return;
        }
        if ("".equals(string3)) {
            DialogUtils.showError("You must specify a password");
            return;
        }
        if ("".equals(string4)) {
            DialogUtils.showError("You must specify a port");
            return;
        }
        if (beaconEntry == null) {
            DialogUtils.showError("You must select a Beacon session!");
            return;
        }
        if (!DialogUtils.isShift(actionEvent)) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
        DialogUtils.openOrActivate(this.client, string);
        for (String string5 : this.targets) {
            taskBeacon.input("ssh " + string5 + ":" + string4 + " " + string2 + " " + string3);
            taskBeacon.SecureShell(string2, string3, string5, CommonUtils.toNumber(string4, 22), -1, null);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.user.setText((String)this.browser.getSelectedValueFromColumn("user"));
        this.pass.setText((String)this.browser.getSelectedValueFromColumn("password"));
    }

    public void show() {
        this.dialog = DialogUtils.dialog("SSH Login", 580, 350);
        this.dialog.addWindowListener(this.browser.onclose());
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        dialogManager.set("port", "22");
        JComponent jComponent = this.browser.getContent();
        this.browser.getTable().getSelectionModel().addListSelectionListener(this);
        this.user = (ATextField)dialogManager.text("user", "User:", 36).get(1);
        this.pass = (ATextField)dialogManager.text("pass", "Password:", 36).get(1);
        dialogManager.text("port", "Port:", 10);
        dialogManager.beacon("bid", "Session:", this.client);
        JButton jButton = dialogManager.action_noclose("Login");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-ssh");
        this.dialog.add((Component)jComponent, "Center");
        this.dialog.add((Component)DialogUtils.stack(dialogManager.layout(), DialogUtils.center(jButton, jButton2)), "South");
        this.dialog.setVisible(true);
    }
}

