/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.TaskBeacon;
import common.BeaconEntry;
import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import ui.ATextField;

public class SecureShellPubKeyDialog
implements DialogListener {
    protected JFrame dialog = null;
    protected AggressorClient client = null;
    protected ATextField user;
    protected ATextField pass;
    protected ATextField port;
    protected String[] targets;
    protected JCheckBox b;

    public SecureShellPubKeyDialog(AggressorClient aggressorClient, String[] stringArray) {
        this.client = aggressorClient;
        this.targets = stringArray;
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        String string = DialogUtils.string(map2, "bid");
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string);
        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{string});
        String string2 = DialogUtils.string(map2, "user");
        String string3 = DialogUtils.string(map2, "key");
        String string4 = DialogUtils.string(map2, "port");
        if ("".equals(string2)) {
            DialogUtils.showError("You must specify a user");
            return;
        }
        if ("".equals(string3)) {
            DialogUtils.showError("You must specify a key file");
            return;
        }
        if ("".equals(string4)) {
            DialogUtils.showError("You must specify a port");
            return;
        }
        if (beaconEntry == null) {
            DialogUtils.showError("You must select a Beacon session!");
            return;
        }
        if (!DialogUtils.isShift(actionEvent)) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
        byte[] byArray = CommonUtils.readFile(string3);
        DialogUtils.openOrActivate(this.client, string);
        for (String string5 : this.targets) {
            taskBeacon.input("ssh-key " + string5 + ":" + string4 + " " + string2 + " " + string3);
            taskBeacon.SecureShellPubKey(string2, byArray, string5, CommonUtils.toNumber(string4, 22), -1, null);
        }
    }

    public void show() {
        this.dialog = DialogUtils.dialog("SSH Login (Key)", 580, 350);
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        dialogManager.set("port", "22");
        dialogManager.text("user", "User:", 24);
        dialogManager.file("key", "PEM File:");
        dialogManager.text("port", "Port:", 10);
        dialogManager.beacon("bid", "Session:", this.client);
        JButton jButton = dialogManager.action_noclose("Login");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-ssh");
        this.dialog.add((Component)dialogManager.layout(), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
    }
}

