/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.DataManager;
import aggressor.DataUtils;
import aggressor.GenericDataManager;
import aggressor.GlobalDataManager;
import common.AObject;
import common.AdjustData;
import common.CommonUtils;
import common.TeamQueue;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.table.TableModel;
import ui.ATable;
import ui.GenericTableModel;

public class SiteChooser
extends AObject
implements AdjustData,
ActionListener {
    protected JFrame dialog = null;
    protected TeamQueue conn = null;
    protected SafeDialogCallback callback = null;
    protected GenericDataManager data = GlobalDataManager.getGlobalDataManager();
    protected DataManager datal = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"Host", "URI", "Port", "Type", "Description"};

    public SiteChooser(TeamQueue teamQueue, DataManager dataManager, SafeDialogCallback safeDialogCallback) {
        this.conn = teamQueue;
        this.callback = safeDialogCallback;
        this.datal = dataManager;
        this.model = DialogUtils.setupModel("URI", this.cols, CommonUtils.apply("sites", DataUtils.getSites(this.data), this));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.model.hasSelectedRows(this.table)) {
            DialogUtils.showError(DialogUtils.MessageID.A_ROW_MUST_BE_SELECTED);
            return;
        }
        String string = (String)this.model.getSelectedValue(this.table);
        String string2 = (String)this.model.getSelectedValueFromColumn(this.table, "Port");
        String string3 = (String)this.model.getSelectedValueFromColumn(this.table, "Host");
        String string4 = (String)this.model.getSelectedValueFromColumn(this.table, "Proto");
        String string5 = string4 + string3 + ":" + string2 + string;
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.callback.dialogResult(string5);
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Choose a site", 640, 240);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.addWindowListener(this.data.unsubOnClose("sites", this));
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, false);
        DialogUtils.setTableColumnWidths(this.table, DialogUtils.toMap("Host: 125, URI: 125, Port: 60, Type: 60, Description: 250"));
        JButton jButton = new JButton("Choose");
        jButton.addActionListener(this);
        this.dialog.add((Component)DialogUtils.FilterAndScroll(this.table), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton), "South");
        this.dialog.setVisible(true);
        this.dialog.show();
    }

    @Override
    public Map format(String string, Object object) {
        Map map2 = (Map)object;
        if ("".equals(map2.get("Host"))) {
            return null;
        }
        if ("beacon".equals(map2.get("Type"))) {
            return null;
        }
        return map2;
    }

    @Override
    public void result(String string, Object object) {
    }
}

