/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import beacon.TaskBeacon;
import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;

public class SleepDialog
implements DialogListener {
    protected AggressorClient client;
    protected String[] bids;
    protected JFrame dialog = null;
    private JButton e;
    private JButton f;

    public SleepDialog(AggressorClient aggressorClient, String[] stringArray) {
        this.client = aggressorClient;
        this.bids = stringArray;
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        boolean bl = true;
        if (actionEvent.getSource() == this.f) {
            return;
        }
        if (actionEvent.getSource() == this.e) {
            String string = DialogUtils.string(map2, "sleep");
            CommonUtils.SleepValues sleepValues = CommonUtils.parseSleepArgs(string);
            if (sleepValues == null) {
                DialogUtils.showError("Failed to parse sleep options '" + string + "'");
                return;
            }
            TaskBeacon taskBeacon = new TaskBeacon(this.client, this.bids);
            taskBeacon.Sleep(sleepValues.Sleep, sleepValues.Jitter);
        }
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Sleep", 640, 480);
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        dialogManager.text("sleep", "Sleep:");
        this.e = dialogManager.action("OK");
        this.f = dialogManager.action("Cancel");
        this.dialog.add((Component)DialogUtils.description("How long should beacon sleep for?\n\nseconds jitter (e.g. '20 25')\nor\n[n]d [n]h [n]m [n]s [n]j (e.g. '1d 13h 34m 45s 25j')", new Dimension(400, 120)), "North");
        this.dialog.add((Component)dialogManager.layout(), "Center");
        this.dialog.add((Component)DialogUtils.center(this.e, this.f), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
    }
}

