/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.browsers.Credentials;
import beacon.TaskBeacon;
import common.ListenerUtils;
import common.ScListener;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ui.ATextField;

public class SpawnAsDialog
implements DialogListener,
ListSelectionListener {
    protected JFrame dialog = null;
    protected AggressorClient client = null;
    protected ATextField user;
    protected ATextField pass;
    protected ATextField domain;
    protected Credentials browser;
    protected String bid;

    public SpawnAsDialog(AggressorClient aggressorClient, String string) {
        this.client = aggressorClient;
        this.browser = new Credentials(aggressorClient);
        this.browser.setColumns("user, password, realm, note");
        this.browser.noHashes();
        this.bid = string;
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        if (this.user.getText() == null || this.user.getText().length() == 0) {
            DialogUtils.showError("You must specify a user!");
            return;
        }
        if (this.pass.getText() == null || this.pass.getText().length() == 0) {
            DialogUtils.showError("You must specify a password!");
            return;
        }
        if (this.domain.getText() == null || this.domain.getText().length() == 0) {
            DialogUtils.showError("You must specify a domain!");
            return;
        }
        String string = DialogUtils.string(map2, "listener");
        ScListener scListener = ListenerUtils.getListener(this.client, string);
        if (scListener == null) {
            DialogUtils.showError("A listener was not selected");
            return;
        }
        if (!DialogUtils.isShift(actionEvent)) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{this.bid});
        DialogUtils.openOrActivate(this.client, this.bid);
        taskBeacon.input("spawnas " + this.domain.getText() + "\\" + this.user.getText() + " " + this.pass.getText() + " " + string);
        taskBeacon.SpawnAs(this.domain.getText(), this.user.getText(), this.pass.getText(), string);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.user.setText((String)this.browser.getSelectedValueFromColumn("user"));
        this.pass.setText((String)this.browser.getSelectedValueFromColumn("password"));
        this.domain.setText((String)this.browser.getSelectedValueFromColumn("realm"));
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Spawn As", 580, 400);
        this.dialog.addWindowListener(this.browser.onclose());
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        JComponent jComponent = this.browser.getContent();
        this.browser.getTable().getSelectionModel().addListSelectionListener(this);
        this.user = (ATextField)dialogManager.text("user", "User:", 36).get(1);
        this.pass = (ATextField)dialogManager.text("pass", "Password:", 36).get(1);
        this.domain = (ATextField)dialogManager.text("domain", "Domain:", 36).get(1);
        dialogManager.sc_listener_all("listener", "Listener:", this.client);
        JButton jButton = dialogManager.action_noclose("Launch");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-spawnas");
        this.dialog.add((Component)jComponent, "Center");
        this.dialog.add((Component)DialogUtils.stackTwo(dialogManager.layout(), DialogUtils.center(jButton, jButton2)), "South");
        this.dialog.setVisible(true);
    }
}

