/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import aggressor.bridges.ArtifactBridge;
import beacon.BeaconSyscallMethod;
import common.CallbackCancelable;
import common.CommonUtils;
import common.ListenerUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;

public class WindowsExecutableStageAllDialog
implements DialogListener,
CallbackCancelable {
    protected JFrame dialog = null;
    protected AggressorClient client;
    protected Map options = null;
    protected ProgressMonitor monitor = null;
    private boolean q = false;

    public WindowsExecutableStageAllDialog(AggressorClient aggressorClient) {
        this.client = aggressorClient;
    }

    @Override
    public boolean result(String string, Object object) {
        switch (string) {
            case "total": {
                this.monitor.setMaximum((Integer)object);
                break;
            }
            case "file": {
                this.monitor.setNote((String)object);
                break;
            }
            case "count": {
                this.monitor.setProgress((Integer)object);
            }
        }
        this.q = this.monitor.isCanceled();
        return this.monitor.isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        this.options = map2;
        String string = DialogUtils.string(map2, "folder");
        boolean bl = DialogUtils.bool(map2, "sign");
        String string2 = DialogUtils.string(map2, "syscall");
        String string3 = DialogUtils.string(map2, "http_library");
        Path path = Paths.get(string, new String[0]);
        boolean bl2 = Files.isDirectory(path, new LinkOption[0]);
        if (!bl2) {
            DialogUtils.showError("Folder does not exist.");
            return;
        }
        List list = ListenerUtils.getListenerNames(this.client);
        this.monitor = new ProgressMonitor(this.client, "Generating Payloads", "Starting...", 0, list.size() * 12);
        this.monitor.setMillisToDecideToPopup(0);
        String[] stringArray = new String[]{};
        try {
            stringArray = ArtifactBridge.generateAllStagelessPayloads(this.client, string, bl, string2, this, string3);
        }
        catch (Exception exception) {
            DialogUtils.showError(exception.getMessage());
        }
        finally {
            this.monitor.close();
        }
        if (!this.q) {
            StringBuilder stringBuilder = new StringBuilder("Payloads saved at " + string);
            if (stringArray.length > 0) {
                stringBuilder.append("\r\n");
                stringBuilder.append("Errors:\r\n");
                for (String string4 : stringArray) {
                    stringBuilder.append(string4 + "\r\n");
                }
                DialogUtils.showError(stringBuilder.toString());
            } else {
                DialogUtils.showInfo(stringBuilder.toString());
            }
        }
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Windows Executable (Stageless) Variants", 640, 480);
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        dialogManager.folder("folder", "Folder:", System.getProperty("user.home"));
        dialogManager.set("syscall", DataUtils.getSystemCallMethod(this.client.getData()));
        dialogManager.combobox("syscall", "System Call:", BeaconSyscallMethod.validSyscalls);
        dialogManager.set("http_library", "");
        dialogManager.combobox("http_library", "HTTP Library:", CommonUtils.toArray(", wininet, winhttp"));
        dialogManager.checkbox_add("sign", "Sign:", "Sign the executable files", DataUtils.getSigner(this.client.getData()).available());
        JButton jButton = dialogManager.action("Generate");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-staged-exe");
        Dimension dimension = DialogUtils.getDescription3LineDimension();
        JComponent jComponent = DialogUtils.description("Generate x86 and x64 stageless payloads for each listener, save to a specified folder, set System Call method, and optionally sign the EXE and DLL files.", dimension);
        this.dialog.add((Component)jComponent, "North");
        this.dialog.add((Component)dialogManager.layout(), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
    }
}

