/*
 * Decompiled with CFR 0.152.
 */
package aggressor.viz;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import common.AObject;
import common.BeaconEntry;
import common.CHECKINSTATE;
import common.Callback;
import common.CommonUtils;
import common.TabScreenshot;
import dialog.DialogUtils;
import graph.GraphPopup;
import graph.NetworkGraph;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class PivotGraph
extends AObject
implements Callback,
GraphPopup {
    protected AggressorClient client = null;
    protected NetworkGraph graph = null;
    protected long last = 0L;

    public PivotGraph(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        this.graph = new NetworkGraph(this.client);
        this.graph.setGraphPopup(this);
        this.graph.addActionForKey("ctrl pressed P", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Image image = PivotGraph.this.graph.getScreenshot();
                byte[] byArray = DialogUtils.toImage((BufferedImage)image, "png");
                PivotGraph.this.client.getConnection().call("aggressor.screenshot", CommonUtils.args(new TabScreenshot("Pivot Graph", byArray)));
                DialogUtils.showInfo("Pushed screenshot to team server");
            }
        });
    }

    public void ready() {
        this.client.getData().subscribe("beacons", this);
    }

    @Override
    public void showGraphPopup(String[] stringArray, MouseEvent mouseEvent) {
        if (stringArray.length > 0) {
            DialogUtils.showSessionPopup(this.client, mouseEvent, stringArray);
        } else {
            Stack<Scalar> stack = new Stack<Scalar>();
            stack.push(SleepUtils.getScalar(this.getContent()));
            this.client.getScriptEngine().getMenuBuilder().installMenu(mouseEvent, "pgraph", stack);
        }
    }

    public void showPopup(MouseEvent mouseEvent) {
        Stack stack = new Stack();
        this.client.getScriptEngine().getMenuBuilder().installMenu(mouseEvent, "beacon", stack);
    }

    public JComponent getContent() {
        return this.graph;
    }

    @Override
    public void result(String string, Object object) {
        Object object2;
        if (!this.graph.isShowing()) {
            return;
        }
        Map map2 = (Map)object;
        long l = CommonUtils.dataIdentity(map2);
        if (l == this.last) {
            return;
        }
        this.last = l;
        this.graph.start();
        if (map2.size() > 0) {
            this.graph.addNode("", "", "", DialogUtils.TargetVisualization("firewall", 0.0, false, CHECKINSTATE.GOOD, false), "", "");
        }
        for (BeaconEntry beaconEntry : map2.values()) {
            Image image = null;
            object2 = DataUtils.getBeaconCheckinState(beaconEntry);
            image = beaconEntry.isEmpty() ? DialogUtils.TargetVisualization("unknown", 0.0, false, object2, true) : DialogUtils.TargetVisualization(beaconEntry.getOperatingSystem().toLowerCase(), beaconEntry.getVersion(), beaconEntry.isAdmin(), object2, true);
            if (beaconEntry.isEmpty()) {
                if ("".equals(beaconEntry.getNote())) {
                    this.graph.addNode(beaconEntry.getId(), "[unknown]", "", image, "", beaconEntry.getAccent());
                } else {
                    this.graph.addNode(beaconEntry.getId(), "[unknown]\n" + beaconEntry.getNote(), "", image, "", beaconEntry.getAccent());
                }
            } else if (beaconEntry.isSSH()) {
                if ("".equals(beaconEntry.getNote())) {
                    this.graph.addNode(beaconEntry.getId(), beaconEntry.getComputer(), beaconEntry.getUser(), image, beaconEntry.getInternal(), beaconEntry.getAccent());
                } else {
                    this.graph.addNode(beaconEntry.getId(), beaconEntry.getComputer() + "\n" + beaconEntry.getNote(), beaconEntry.getUser(), image, beaconEntry.getInternal(), beaconEntry.getAccent());
                }
            } else if ("".equals(beaconEntry.getNote())) {
                this.graph.addNode(beaconEntry.getId(), beaconEntry.getComputer() + " @ " + beaconEntry.getPid(), beaconEntry.getUser(), image, beaconEntry.getInternal(), beaconEntry.getAccent());
            } else {
                this.graph.addNode(beaconEntry.getId(), beaconEntry.getComputer() + " @ " + beaconEntry.getPid() + "\n" + beaconEntry.getNote(), beaconEntry.getUser(), image, beaconEntry.getInternal(), beaconEntry.getAccent());
            }
            if (beaconEntry.getParentId().length() != 0) continue;
            if ("".equals(beaconEntry.getExternal())) {
                this.graph.addEdge("", beaconEntry.getId(), "#FFFF00", "4", "true", "", 2);
                continue;
            }
            this.graph.addEdge("", beaconEntry.getId(), "#00FF00", "4", "true", "", 2);
        }
        for (BeaconEntry beaconEntry : map2.values()) {
            if (beaconEntry.getParentId().length() <= 0) continue;
            object2 = "";
            String string2 = "";
            int n = beaconEntry.getPivotHint().isForward() ? 1 : 2;
            if (beaconEntry.getPivotHint().isTCP()) {
                if (beaconEntry.getLinkState() == 1) {
                    object2 = "#00FFA5";
                    string2 = "";
                } else {
                    object2 = "#A500FF";
                    string2 = "DISCONNECTED";
                }
            } else if (beaconEntry.getLinkState() == 1) {
                object2 = "#FFA500";
                string2 = "";
            } else {
                object2 = "#FF0000";
                string2 = "DISCONNECTED";
            }
            if ("DISCONNECTED".equals(string2)) {
                this.graph.disconnected(beaconEntry.getId());
            }
            this.graph.addEdge(beaconEntry.getParentId(), beaconEntry.getId(), (String)object2, "4", "false", string2, n);
        }
        this.graph.deleteNodes();
        this.graph.end();
    }
}

