/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.TranscriptEditor;
import common.AObject;
import common.AdjustData;
import common.CommonUtils;
import common.DownloadFile;
import common.DownloadNotify;
import common.Helper;
import common.Keystrokes;
import common.MudgeSanity;
import common.ScriptUtils;
import console.Colors;
import console.Display;
import dialog.DialogUtils;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.text.DefaultStyledDocument;
import sleep.runtime.Scalar;
import ui.DataBrowser;
import ui.DataSelectionListener;
import ui.TablePopup;

public class KeystrokeBrowser
extends AObject
implements AdjustData,
DataSelectionListener,
TablePopup,
DownloadNotify {
    protected AggressorClient client = null;
    protected DataBrowser browser = null;
    protected Display content = null;
    protected Map sessions = new HashMap();
    protected Colors colors = new Colors(new Properties());
    protected TranscriptEditor editor = new TranscriptEditor();
    protected ByteArrayOutputStream out = null;

    public KeystrokeBrowser(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        aggressorClient.getData().populateAndSubscribe("accents", this);
        aggressorClient.getData().populateAndSubscribe("keystrokes.delete", this);
        Helper helper = new Helper();
        if (!helper.startHelper(this.getClass())) {
            System.exit(0);
        }
    }

    public ActionListener cleanup() {
        return this.client.getData().unsubOnClose("keystrokes, accents", this);
    }

    public JComponent getContent() {
        this.client.getData().populateAndSubscribe("keystrokes", this);
        LinkedList linkedList = new LinkedList(this.sessions.values());
        this.content = new Display(new Properties());
        this.browser = DataBrowser.getKeystrokeDataBrowser("object", this.content, linkedList);
        this.browser.addDataSelectionListener(this);
        this.browser.getTable().setPopupMenu(this);
        DialogUtils.setupDateRenderer(this.browser.getTable(), "when");
        this.editor.setTable(this.browser.getTable(), this.browser.getModel());
        return this.browser;
    }

    @Override
    public void selected(Object object) {
        if (object != null) {
            this.content.clear();
            this.out = new ByteArrayOutputStream();
            Keystrokes keystrokes = (Keystrokes)object;
            new DownloadFile(this.client.getConnection(), keystrokes.ID(), this.out, this).startKeystrokes();
        } else {
            this.content.clear();
        }
    }

    @Override
    public void complete(String string) {
        try {
            final String string2 = new String(this.out.toByteArray(), StandardCharsets.UTF_8);
            this.out.close();
            CommonUtils.runSafe(new Runnable(){

                @Override
                public void run() {
                    DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
                    KeystrokeBrowser.this.colors.append(defaultStyledDocument, string2);
                    KeystrokeBrowser.this.content.swap(defaultStyledDocument);
                    KeystrokeBrowser.this.content.getConsole().setCaretPosition(defaultStyledDocument.getLength());
                }
            });
        }
        catch (IOException iOException) {
            MudgeSanity.logException("KeystrokesBrowser failed to close stream", iOException, false);
        }
    }

    @Override
    public void cancel() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("KeystrokesBrowser failed to close stream", iOException, false);
        }
    }

    @Override
    public Map format(String string, Object object) {
        Map map2;
        if (this.editor.processTranscriptResult(string, object)) {
            return null;
        }
        Keystrokes keystrokes = (Keystrokes)object;
        if (this.editor.isRemoved(keystrokes)) {
            this.sessions.remove(keystrokes.ID());
            return null;
        }
        if (!this.sessions.containsKey(keystrokes.ID())) {
            map2 = keystrokes.toMap();
            map2.put("object", keystrokes);
            this.sessions.put(keystrokes.ID(), map2);
        }
        map2 = (Map)this.sessions.get(keystrokes.ID());
        Map map3 = keystrokes.toMap();
        map3.put("object", keystrokes);
        map2.putAll(map3);
        return this.editor.decorate((Keystrokes)object, map2);
    }

    @Override
    public void result(String string, Object object) {
        if (this.editor.processTranscriptResult(string, object)) {
            return;
        }
        if ("keystrokes.delete".equals(string) && object instanceof String[]) {
            for (String string2 : (String[])object) {
                this.browser.removeEntry("id", string2);
            }
        } else {
            this.format(string, object);
            if (this.browser == null) {
                return;
            }
            this.browser.setTable(this.sessions.values());
        }
    }

    @Override
    public void showPopup(MouseEvent mouseEvent) {
        Map map2 = this.browser.getSelectedRow();
        if (map2 != null) {
            Stack<Scalar> stack = new Stack<Scalar>();
            stack.push(ScriptUtils.convertAll(map2));
            this.client.getScriptEngine().getMenuBuilder().installMenu(mouseEvent, "keystrokes", stack);
        }
    }
}

