/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.Aggressor;
import aggressor.AggressorClient;
import aggressor.Prefs;
import common.AObject;
import common.CommonUtils;
import common.MudgeSanity;
import cortana.Cortana;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import sleep.error.YourCodeSucksException;
import ui.ATable;
import ui.GenericTableModel;

public class ScriptManager
extends AObject
implements ActionListener,
SafeDialogCallback {
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"path", "ready"};
    protected AggressorClient client = null;

    public ScriptManager(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        this.model = DialogUtils.setupModel("path", this.cols, this.toModel());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Load".equals(actionEvent.getActionCommand())) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list = runtimeMXBean.getInputArguments();
            for (String string : list) {
                if (string == null || !string.toLowerCase().contains("-javaagent:")) continue;
                System.exit(0);
            }
            SafeDialogs.openFile("Load a script", null, null, false, false, this);
        } else if ("Unload".equals(actionEvent.getActionCommand())) {
            Object object2;
            if (!this.model.hasSelectedRows(this.table)) {
                DialogUtils.showError(DialogUtils.MessageID.A_ROW_MUST_BE_SELECTED);
                return;
            }
            String string = this.model.getSelectedValue(this.table) + "";
            for (Object object2 : Aggressor.getFrame().getScriptEngines()) {
                ((Cortana)object2).unloadScript(string);
            }
            object2 = Prefs.getPreferences().getList("cortana.scripts");
            object2.remove(string);
            Prefs.getPreferences().setList("cortana.scripts", (List)object2);
            Prefs.getPreferences().save();
            this.refresh();
        } else if ("Reload".equals(actionEvent.getActionCommand())) {
            if (!this.model.hasSelectedRows(this.table)) {
                DialogUtils.showError(DialogUtils.MessageID.A_ROW_MUST_BE_SELECTED);
                return;
            }
            String string = this.model.getSelectedValue(this.table) + "";
            try {
                this.client.getScriptEngine().unloadScript(string);
                this.client.getScriptEngine().loadScript(string);
                DialogUtils.showInfo("Reloaded " + string);
            }
            catch (YourCodeSucksException yourCodeSucksException) {
                MudgeSanity.logException("Load " + string, yourCodeSucksException, true);
                DialogUtils.showError("Could not load " + string + ":\n\n" + yourCodeSucksException.formatErrors());
            }
            catch (Exception exception) {
                MudgeSanity.logException("Load " + string, exception, false);
                DialogUtils.showError("Could not load " + string + "\n" + exception.getMessage());
            }
            try {
                for (Cortana cortana : Aggressor.getFrame().getOtherScriptEngines(this.client)) {
                    cortana.unloadScript(string);
                    cortana.loadScript(string);
                }
            }
            catch (Exception exception) {
                MudgeSanity.logException("Load " + string, exception, false);
            }
            this.refresh();
        }
    }

    @Override
    public void dialogResult(String string) {
        try {
            Object object2;
            this.client.getScriptEngine().loadScript(string);
            for (Object object2 : Aggressor.getFrame().getOtherScriptEngines(this.client)) {
                ((Cortana)object2).loadScript(string);
            }
            object2 = Prefs.getPreferences().getList("cortana.scripts");
            object2.add(string);
            Prefs.getPreferences().setList("cortana.scripts", (List)object2);
            Prefs.getPreferences().save();
            this.refresh();
        }
        catch (YourCodeSucksException yourCodeSucksException) {
            MudgeSanity.logException("Load " + string, yourCodeSucksException, true);
            DialogUtils.showError("Could not load " + string + ":\n\n" + yourCodeSucksException.formatErrors());
        }
        catch (Exception exception) {
            MudgeSanity.logException("Load " + string, exception, false);
            DialogUtils.showError("Could not load " + string + "\n" + exception.getMessage());
        }
    }

    public void refresh() {
        DialogUtils.setTable(this.table, this.model, this.toModel());
    }

    public LinkedList toModel() {
        HashSet hashSet = new HashSet(this.client.getScriptEngine().getScripts());
        Iterator iterator = Prefs.getPreferences().getList("cortana.scripts").iterator();
        LinkedList<Map> linkedList = new LinkedList<Map>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (hashSet.contains(new File(string).getName())) {
                linkedList.add(CommonUtils.toMap("path", string, "ready", "\u2713"));
                continue;
            }
            linkedList.add(CommonUtils.toMap("path", string, "ready", ""));
        }
        return linkedList;
    }

    public JComponent getContent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        DialogUtils.setTableColumnWidths(this.table, DialogUtils.toMap("path: 240, ready: 64"));
        this.table.getColumn("ready").setPreferredWidth(64);
        this.table.getColumn("ready").setMaxWidth(64);
        JButton jButton = new JButton("Load");
        JButton jButton2 = new JButton("Unload");
        JButton jButton3 = new JButton("Reload");
        JButton jButton4 = new JButton("Help");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jButton4.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-scripting"));
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        jPanel.add((Component)DialogUtils.center(jButton, jButton2, jButton3, jButton4), "South");
        return jPanel;
    }
}

