/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import aggressor.windows.BeaconConsole;
import beacon.BeaconCommands;
import beacon.SecureShellTabCompletion;
import common.BeaconOutput;
import common.Callback;
import common.CommandParser;
import common.CommonUtils;
import console.Colors;
import console.GenericTabCompletion;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.JTextField;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class SecureShellConsole
extends BeaconConsole {
    public SecureShellConsole(String string, AggressorClient aggressorClient) {
        super(string, aggressorClient);
    }

    @Override
    public String getPrompt() {
        return Colors.underline("ssh") + "> ";
    }

    @Override
    public String Script(String string) {
        return "SSH_" + string;
    }

    @Override
    public GenericTabCompletion getTabCompletion() {
        return new SecureShellTabCompletion(this.bid, this.client, this.console);
    }

    @Override
    public void showPopup(String string, MouseEvent mouseEvent) {
        Stack<Scalar> stack = new Stack<Scalar>();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.bid);
        stack.push(SleepUtils.getArrayWrapper(linkedList));
        this.engine.getMenuBuilder().installMenu(mouseEvent, "ssh", stack);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getActionCommand().trim();
        ((JTextField)actionEvent.getSource()).setText("");
        try {
            object = this.console.processHistoryBang((String)object2);
            if (!((String)object).isEmpty()) {
                this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
                object2 = object;
            }
        }
        catch (Exception exception) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            this.console.append(exception.getMessage() + "\n");
            return;
        }
        this.console.addCommandToHistory((String)object2);
        object = new CommandParser((String)object2);
        if (this.client.getSSHAliases().isAlias(((CommandParser)object).getCommand())) {
            this.master.input((String)object2);
            this.client.getSSHAliases().fireCommand(this.bid, ((CommandParser)object).getCommand(), ((CommandParser)object).getArguments());
            return;
        }
        if (((CommandParser)object).is("help") || ((CommandParser)object).is("?")) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            if (((CommandParser)object).verify("Z") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                BeaconCommands beaconCommands = DataUtils.getSSHCommands(this.data);
                if (beaconCommands.isHelpAvailable(string)) {
                    Stack<Scalar> stack = new Stack<Scalar>();
                    stack.push(SleepUtils.getScalar(string));
                    this.console.append(this.engine.format("SSH_OUTPUT_HELP_COMMAND", stack) + "\n");
                } else {
                    ((CommandParser)object).error("no help is available for '" + string + "'");
                }
            } else {
                this.console.append(this.engine.format("SSH_OUTPUT_HELP", new Stack()) + "\n");
            }
            if (((CommandParser)object).hasError()) {
                this.console.append(this.formatLocal(BeaconOutput.Error(this.bid, ((CommandParser)object).error())) + "\n");
            }
            return;
        }
        if (((CommandParser)object).is("history")) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            int n = ((CommandParser)object).popHistoryArgument();
            if (((CommandParser)object).hasError()) {
                this.console.append(this.formatLocal(BeaconOutput.Error(this.bid, ((CommandParser)object).error())) + "\n");
            } else {
                this.getConsole().showHistory(n);
            }
            return;
        }
        if (((CommandParser)object).is("downloads")) {
            this.console.append(this.formatLocal(BeaconOutput.Input(this.bid, (String)object2)) + "\n");
            this.conn.call("beacons.downloads", CommonUtils.args(this.bid), new Callback(){

                @Override
                public void result(String string, Object object) {
                    Stack<Scalar> stack = new Stack<Scalar>();
                    stack.push(CommonUtils.convertAll(object));
                    stack.push(SleepUtils.getScalar(SecureShellConsole.this.bid));
                    SecureShellConsole.this.console.append(SecureShellConsole.this.engine.format("BEACON_OUTPUT_DOWNLOADS", stack) + "\n");
                }
            });
            return;
        }
        this.master.input((String)object2);
        if (((CommandParser)object).is("cancel")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Cancel(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("cd")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Cd(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("clear")) {
            this.master.Clear();
        } else if (((CommandParser)object).is("connect")) {
            if (((CommandParser)object).verify("AI") || ((CommandParser)object).reset()) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                this.master.Connect(string, n);
            } else if (((CommandParser)object).verify("Z")) {
                String string = ((CommandParser)object).popString();
                this.master.Connect(string);
            }
        } else if (((CommandParser)object).is("download")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Download(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("exit")) {
            this.master.Die();
        } else if (((CommandParser)object).is("getuid")) {
            this.master.GetUID();
        } else if (((CommandParser)object).is("note")) {
            if (((CommandParser)object).verify("Z")) {
                String string = ((CommandParser)object).popString();
                this.master.Note(string);
            } else if (((CommandParser)object).isMissingArguments()) {
                this.master.Note("");
            }
        } else if (((CommandParser)object).is("pwd")) {
            this.master.Pwd();
        } else if (((CommandParser)object).is("rportfwd")) {
            if (((CommandParser)object).verify("IAI") || ((CommandParser)object).reset()) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                int n2 = ((CommandParser)object).popInt();
                this.master.PortForward(n2, string, n);
            } else if (((CommandParser)object).verify("AI")) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                if (!"stop".equals(string)) {
                    ((CommandParser)object).error("only acceptable argument is stop");
                } else {
                    this.master.PortForwardStop(n);
                }
            }
        } else if (((CommandParser)object).is("rportfwd_local")) {
            if (((CommandParser)object).verify("IAI") || ((CommandParser)object).reset()) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                int n3 = ((CommandParser)object).popInt();
                this.master.PortForwardLocal(n3, string, n);
            } else if (((CommandParser)object).verify("AI")) {
                int n = ((CommandParser)object).popInt();
                String string = ((CommandParser)object).popString();
                if (!"stop".equals(string)) {
                    ((CommandParser)object).error("only acceptable argument is stop");
                } else {
                    this.master.PortForwardStop(n);
                }
            }
        } else if (((CommandParser)object).is("shell")) {
            if (((CommandParser)object).verify("Z")) {
                this.master.Shell(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("sleep")) {
            if (((CommandParser)object).verify("Z")) {
                String string = ((CommandParser)object).popString();
                CommonUtils.SleepValues sleepValues = CommonUtils.parseSleepArgs(string);
                if (sleepValues == null) {
                    ((CommandParser)object).error("Failed to parse sleep options '" + string + "'");
                } else {
                    this.master.Sleep(sleepValues.Sleep, sleepValues.Jitter);
                }
            }
        } else if (((CommandParser)object).is("socks")) {
            if (((CommandParser)object).verify("I") || ((CommandParser)object).reset()) {
                this.master.SocksStart(((CommandParser)object).popInt());
            } else if (((CommandParser)object).verify("Z")) {
                if (!((CommandParser)object).popString().equals("stop")) {
                    ((CommandParser)object).error("only acceptable argument is stop or port");
                } else {
                    this.master.SocksStop();
                }
            }
        } else if (((CommandParser)object).is("sudo")) {
            if (((CommandParser)object).verify("AZ")) {
                String string = ((CommandParser)object).popString();
                String string2 = ((CommandParser)object).popString();
                this.master.ShellSudo(string2, string);
            }
        } else if (((CommandParser)object).is("unlink")) {
            if (((CommandParser)object).verify("AI") || ((CommandParser)object).reset()) {
                String string = ((CommandParser)object).popString();
                String string3 = ((CommandParser)object).popString();
                this.master.Unlink(string3, string);
            } else if (((CommandParser)object).verify("Z")) {
                this.master.Unlink(((CommandParser)object).popString());
            }
        } else if (((CommandParser)object).is("upload") && ((CommandParser)object).empty()) {
            SafeDialogs.openFile("Select file to upload", null, null, false, false, new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    if (CommonUtils.lof(string) > 786432L) {
                        SecureShellConsole.this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Error(SecureShellConsole.this.bid, "File " + string + " is larger than 768KB")));
                    } else {
                        SecureShellConsole.this.master.Upload(string);
                    }
                }
            });
        } else if (((CommandParser)object).is("upload")) {
            if (((CommandParser)object).verify("F")) {
                String string = ((CommandParser)object).popString();
                if (CommonUtils.lof(string) > 786432L) {
                    this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Error(this.bid, "File " + string + " is larger than 768KB")));
                } else {
                    this.master.Upload(string);
                }
            }
        } else {
            this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Error(this.bid, "Unknown command: " + (String)object2)));
        }
        if (((CommandParser)object).hasError()) {
            this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Error(this.bid, ((CommandParser)object).error())));
        }
    }
}

