/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import beacon.Settings;
import common.CommonUtils;
import common.Guardrails;
import common.ScListener;
import java.nio.ByteBuffer;

public class BeaconGuardrails {
    protected static String GUARD_PATCH_MARKER = "GGGGuuuuaaaarrrrddddRRRRaaaaiiiillllssssPPPPaaaayyyyllllooooaaaadddd";
    protected static int GUARD_PATCH_LENGTH = 2048;
    public static final int GUARD_USER = 5;
    public static final int GUARD_COMPUTER = 6;
    public static final int GUARD_DOMAIN = 7;
    public static final int GUARD_LOCAL_IP = 8;
    public static final int GUARD_PAYLOAD_CHECKSUM = 9;
    private String D = null;
    private String F = null;
    private String B = null;
    private String C = null;
    private boolean A = false;
    private int E = 0;

    protected static byte[] buildGuardPatch(Settings settings, byte[] byArray) {
        byte[] byArray2 = settings.toPatch(GUARD_PATCH_LENGTH);
        byte[] byArray3 = new byte[]{-118};
        byArray2 = BeaconGuardrails.mask_forwards(byArray2, byArray3);
        byArray2 = BeaconGuardrails.mask_backwards(byArray2, byArray);
        return byArray2;
    }

    protected static byte[] mask_forwards(byte[] byArray, byte[] byArray2) {
        int n = 0;
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            n = i % byArray2.length;
            byArray3[i] = (byte)(byArray[i] ^ byArray2[n]);
        }
        return byArray3;
    }

    protected static byte[] mask_backwards(byte[] byArray, byte[] byArray2) {
        int n = 0;
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            n = byArray2.length - 1 - i % byArray2.length;
            byArray3[i] = (byte)(byArray[i] ^ byArray2[n]);
        }
        return byArray3;
    }

    protected static int quickChecksum(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            l = (l + (long)(n * (i % 3 + 1))) % 99999999L;
        }
        return (int)l;
    }

    protected static final String applyPatch(String string, Settings settings, byte[] byArray) {
        int n = string.indexOf(GUARD_PATCH_MARKER);
        if (n > -1) {
            byte[] byArray2 = BeaconGuardrails.buildGuardPatch(settings, byArray);
            String string2 = CommonUtils.bString(byArray2);
            return CommonUtils.replaceAt(string, string2, n);
        }
        return string;
    }

    protected BeaconGuardrails(ScListener scListener) {
        this(scListener.getGuards());
    }

    protected BeaconGuardrails(String string) {
        Guardrails guardrails = Guardrails.parseTabDelString(string);
        if (!CommonUtils.isNullOrEmpty(guardrails.ipaddress)) {
            this.setLocalIPAddress(guardrails.ipaddress.trim());
        }
        if (!CommonUtils.isNullOrEmpty(guardrails.user)) {
            this.setUserName(guardrails.user.trim());
        }
        if (!CommonUtils.isNullOrEmpty(guardrails.server)) {
            this.setComputer(guardrails.server.trim());
        }
        if (!CommonUtils.isNullOrEmpty(guardrails.domain)) {
            this.setDomain(guardrails.domain.trim());
        }
    }

    protected Settings buildGuardSettings() {
        Settings settings = new Settings(GUARD_PATCH_LENGTH);
        if (this.guardsUsername()) {
            if (this.D.endsWith("*")) {
                settings.addShort(5, 1 + (this.D.length() - 1));
            } else if (this.D.startsWith("*")) {
                settings.addShort(5, 257 + (this.D.length() - 1));
            } else {
                settings.addShort(5, 1);
            }
        }
        if (this.guardsComputer()) {
            if (this.F.endsWith("*")) {
                settings.addShort(6, 1 + (this.F.length() - 1));
            } else if (this.F.startsWith("*")) {
                settings.addShort(6, 257 + (this.F.length() - 1));
            } else {
                settings.addShort(6, 1);
            }
        }
        if (this.guardsDomain()) {
            if (this.B.endsWith("*")) {
                settings.addShort(7, 1 + (this.B.length() - 1));
            } else if (this.B.startsWith("*")) {
                settings.addShort(7, 257 + (this.B.length() - 1));
            } else {
                settings.addShort(7, 1);
            }
        }
        if (this.guardsLocalIPAddress()) {
            settings.addInt(8, this.getLocalIPAddressSegmentCount());
        }
        if (this.guardsPayloadChecksum()) {
            settings.addInt(9, this.E);
        }
        return settings;
    }

    protected byte[] hashWithUsername(byte[] byArray) {
        if (this.guardsUsername()) {
            String string = this.getUsername().toLowerCase();
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            } else if (string.startsWith("*")) {
                string = string.substring(1);
            }
            byte[] byArray2 = CommonUtils.toBytes(string);
            byte[] byArray3 = BeaconGuardrails.mask_forwards(byArray, byArray2);
            this.setPayloadChecksumChecked(true);
            return byArray3;
        }
        return byArray;
    }

    protected byte[] hashWithComputer(byte[] byArray) {
        if (this.guardsComputer()) {
            String string = this.getComputer().toLowerCase();
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            } else if (string.startsWith("*")) {
                string = string.substring(1);
            }
            byte[] byArray2 = CommonUtils.toBytes(string);
            byte[] byArray3 = BeaconGuardrails.mask_forwards(byArray, byArray2);
            this.setPayloadChecksumChecked(true);
            return byArray3;
        }
        return byArray;
    }

    protected byte[] hashWithDomain(byte[] byArray) {
        if (this.guardsDomain()) {
            String string = this.getDomain().toLowerCase();
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            } else if (string.startsWith("*")) {
                string = string.substring(1);
            }
            byte[] byArray2 = CommonUtils.toBytes(string);
            byte[] byArray3 = BeaconGuardrails.mask_forwards(byArray, byArray2);
            this.setPayloadChecksumChecked(true);
            return byArray3;
        }
        return byArray;
    }

    protected byte[] hashWithLocalIP(byte[] byArray) {
        if (this.guardsLocalIPAddress()) {
            String string = this.getLocalIPAddressString();
            string = string.replace("*", "0");
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.putInt((int)CommonUtils.ipToLong(string));
            byte[] byArray2 = byteBuffer.array();
            byte[] byArray3 = BeaconGuardrails.mask_forwards(byArray, byArray2);
            this.setPayloadChecksumChecked(true);
            return byArray3;
        }
        return byArray;
    }

    protected boolean guardsUsername() {
        return !CommonUtils.isNullOrEmpty(this.D);
    }

    protected boolean guardsComputer() {
        return !CommonUtils.isNullOrEmpty(this.F);
    }

    protected boolean guardsDomain() {
        return !CommonUtils.isNullOrEmpty(this.B);
    }

    protected boolean guardsLocalIPAddress() {
        return !CommonUtils.isNullOrEmpty(this.C);
    }

    protected boolean guardsPayloadChecksum() {
        return this.isPayloadChecksumChecked() && this.E > 0;
    }

    public String getUsername() {
        return this.D;
    }

    public void setUserName(String string) {
        this.D = string;
    }

    public String getComputer() {
        return this.F;
    }

    public void setComputer(String string) {
        this.F = string;
    }

    public String getDomain() {
        return this.B;
    }

    public void setDomain(String string) {
        this.B = string;
    }

    public String getLocalIPAddressString() {
        return this.C;
    }

    public void setLocalIPAddress(String string) {
        this.C = string;
    }

    public boolean isPayloadChecksumChecked() {
        return this.A;
    }

    public void setPayloadChecksumChecked(boolean bl) {
        this.A = bl;
    }

    public int getPayloadChecksum() {
        return this.E;
    }

    public void setPayloadChecksum(int n) {
        this.E = n;
    }

    public int getLocalIPAddressSegmentCount() {
        if (!this.guardsLocalIPAddress()) {
            return 0;
        }
        String string = this.getLocalIPAddressString();
        if (string.endsWith(".*.*.*")) {
            return 1;
        }
        if (string.endsWith(".*.*")) {
            return 2;
        }
        if (string.endsWith(".*")) {
            return 3;
        }
        return 4;
    }
}

